﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.GameServers.Extensions;
using Curse.GameServers.Configuration;

namespace Curse.GameServers.Caching
{
    public class GameServerTagCache
    {
        private Dictionary<int, List<CTag>> _gameServerTagsByGameServerId;
        private object _gameServerTagLock = new object();

        private static readonly GameServerTagCache _instance = new GameServerTagCache();
        public static GameServerTagCache Instance { get { return _instance; } }

        private GameServerTagCache()
        {
            _gameServerTagsByGameServerId = new  Dictionary<int, List<CTag>>();
        }

        public Dictionary<int, List<CTag>> GetGameServerTagCache(SqlConnection conn, int gameServerEntityTypeId)
        {
            var gameServerTags = new Dictionary<int, List<CTag>>();

            var query = "SELECT Tag.ID, Tag.Text, Tag.Slug, TagEntityMap.EntityID " + 
                "FROM Tag WITH(NOLOCK) INNER JOIN TagEntityMap ON TagEntityMap.TagID = Tag.ID " + 
                "WHERE TagEntityMap.EntityTypeID = @EntityTypeID";

            var cmd = new SqlCommand(query, conn);
            cmd.Parameters.Add("EntityTypeID", System.Data.SqlDbType.Int).Value = gameServerEntityTypeId;

            using (var reader = cmd.ExecuteReader())
            {
                while (reader.Read())
                {
                    var entityId = reader.GetInt32(reader.GetOrdinal("EntityID"));
                    if (!gameServerTags.ContainsKey(entityId))
                    {
                        gameServerTags.Add(entityId, new List<CTag>());
                    }

                    var tag = new CTag();
                    tag.SetFromDataReader(reader);
                    gameServerTags[entityId].Add(tag);
                }

                lock (_gameServerTagLock)
                {
                    _gameServerTagsByGameServerId = gameServerTags;
                }

                return gameServerTags;
            }
        }

        public void UploadIcon()
        {
            using (SqlConnection conn = DatabaseConfiguration.GetGameServerConnection())
            {
                IEnumerable<Site> sites = Site.GetAll(conn);
                //    Dictionary<int, IEnumerable<int[]>> spriteDimensions = GlobalSetting.Get<Dictionary<int, IEnumerable<int[]>>>("ChampionSpriteDimensionsBySite", () =>
                //    {
                //        Dictionary<int, IEnumerable<int[]>> spriteDimensionsBySite = new Dictionary<int, IEnumerable<int[]>>();
                //        foreach (Site site in sites)
                //        {
                //            spriteDimensionsBySite.Add(site.ID, new[] { new int[] { 85, 85 }, new int[] { 35, 35 } });
                //        }
                //        return spriteDimensionsBySite;
                //    });

                //    long now = DateTime.UtcNow.Ticks;
                //    foreach (Site site in sites)
                //    {
                //        AddLogMessage("Generating sprites for {0}".FormatWith(site.Title));
                //        IEnumerable<int> gameIDs = ((int[])site.DynamicPreferences.SupportedGames).AsEnumerable();
                //        if (gameIDs != null && gameIDs.Any())
                //        {
                //            IEnumerable<Game> supportedGames = Game.GetAllByIDs(gameIDs);
                //            foreach (Game game in supportedGames)
                //            {
                //                string prefix = "champions-{0}".FormatWith(game.Slug);
                //                // Verbose query to make sure we get them back by ID - this way additions of champions in the future won't change the location of images in the sprite
                //                IEnumerable<GameChampion> champs = GameChampion.GetQueryByGame(game).OrderBy(gc => gc.ID).ToArray();
                //                if (champs.Any())
                //                {
                //                    IEnumerable<SpriteDescription> spriteDescriptions = champs.Select(c => new SpriteDescription((IThumbnailable)c.Avatar, c.Name.ToSlug()));

                //                    string[] cssIncludes = site.ExtraCssIncludes;

                //                    // Build all configured dimensions
                //                    HashSet<string> spriteCssUrls = cssIncludes != null ? cssIncludes.ToSet() : new HashSet<string>();
                //                    foreach (int[] dim in spriteDimensions[site.ID])
                //                    {
                //                        string url = SpriteBuilder.BuildSprite(prefix, spriteDescriptions, new Point(dim[0], dim[1]), ImageFormat.Jpeg, site.ID);
                //                        // Remove old instance of URL if it exists
                //                        spriteCssUrls.RemoveWhere(u => u.StartsWith(url));
                //                        // Append a cache breaker based on the sprite generation time
                //                        spriteCssUrls.Add("{0}?{1}".FormatWith(url, now));
                //                        AddLogMessage("Created sprite CSS {0}".FormatWith(url));
                //                    }

                //                    // Set CSS urls to be included on master page
                //                    site.ExtraCssIncludes = spriteCssUrls.ToArray();
                //                }
                //            }
                //        }
                //    }
            }
        }
    }
}