﻿using System;
using System.Configuration;
using System.Data.SqlClient;

namespace Curse.GameServers.Configuration
{
    public class DatabaseConfiguration
    {
        private static string _gameServerConnectionString;

        static DatabaseConfiguration()
        {
            _gameServerConnectionString = ConfigurationManager.ConnectionStrings["GameServers"].ConnectionString;
        }

        public static SqlConnection GetGameServerConnection()
        {
            var conn = new SqlConnection(_gameServerConnectionString);
            try
            {
                conn.Open();
            }
            catch (Exception)
            {                
                Logger.Log(ELogLevel.Info, "localhost", "Unable to establish connection to database:" + DateTime.Now.ToString());
                throw;
            }
            return conn;
        }
    }
}