﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.GameServers.Extensions
{
    public static class CGamePlayerExtensions
    {
        public static void SetFromDataReader(this CGamePlayer player, SqlDataReader reader)
        {
            player.ID = reader.GetInt32(reader.GetOrdinal("GamePlayerID"));
            player.Name = reader.GetString(reader.GetOrdinal("Name"));
            player.Slug = reader.GetString(reader.GetOrdinal("Slug"));
        }

        public static void SetFromDataReader(this CGameServerPlayer player, SqlDataReader reader)
        {
            player.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            player.GameServerID = reader.GetInt32(reader.GetOrdinal("GameServerID"));
            player.GamePlayerID = reader.GetInt32(reader.GetOrdinal("GamePlayerID"));
            player.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            player.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            player.Score = reader.GetNullableValue<string>("Score");
            player.Deaths = reader.GetNullableValue<int>("Deaths");
            player.TeamName = reader.GetNullableValue<string>("TeamName");
        }
    }
}