﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Data.SqlClient;
using Curse.GameServers.Caching;
using Curse.Extensions;
using System.Net;
using Curse.GameServers.Geocoding;

namespace Curse.GameServers.Extensions
{
    public static class CGameServerExtension
    {
        public static void SetFromDataReader(this CGameServer gameServer, SqlConnection conn, SqlDataReader reader, Dictionary<int, List<CGameServerPlayer>> playerCache, Dictionary<int, List<CGameServerProperty>> gameProperties, Dictionary<int, List<CTag>> gameServerTags, List<CGameServerRating> gameServerRatings, Dictionary<int, List<int>> pluginsByServerID)
        {
            gameServer.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            gameServer.GameServerDataSourceID = reader.GetInt32(reader.GetOrdinal("GameServerDataSourceID"));

            gameServer.GameServerTypeID = reader.GetNullableValue<int>("GameServerTypeID");
            var dataSourceServerTypes = GameServerTypeCache.Instance.GetAllGameServerTypesByDataSouce(gameServer.GameServerDataSourceID);
            if (dataSourceServerTypes != null)
            {
                gameServer.GameServerType = dataSourceServerTypes.FirstOrDefault(p => p.ID == gameServer.GameServerTypeID);
            }

            gameServer.DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            gameServer.DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            gameServer.GameServerStatus = (GameServerStatus)reader.GetByte(reader.GetOrdinal("Status"));

            //int addressLength = reader.GetInt32(reader.GetOrdinal("IpAddressLength"));
            //gameServer.IPAddress = new byte[addressLength];
            //reader.GetBytes(reader.GetOrdinal("IPAddress"), 0, gameServer.IPAddress, 0, addressLength);
            gameServer.IPAddress = (byte[])reader.GetValue(reader.GetOrdinal("IPAddress"));
            
            gameServer.Port = reader.GetInt32(reader.GetOrdinal("Port"));
            gameServer.HostName = reader.GetNullableValue<string>("HostName");
            gameServer.Title = reader.GetNullableValue<string>("Title");
            gameServer.Slug = reader.GetString(reader.GetOrdinal("Slug"));
            gameServer.Description = reader.GetNullableValue<string>("Description");
            gameServer.Url = reader.GetNullableValue<string>("Url");
            gameServer.MaxPlayers = reader.GetNullableValue<int>("MaxPlayers");
            gameServer.PlayersOnline = reader.GetNullableValue<int>("PlayersOnline");
            gameServer.MoTD = reader.GetNullableValue<string>("MoTD");
            gameServer.Version = reader.GetNullableValue<string>("Version");
            gameServer.Latency = reader.GetNullableValue<long>("Latency");
            gameServer.DateLastMined = reader.GetNullableValue<DateTime>("DateLastMined");
            gameServer.CacheDate = gameServer.DateLastMined;
            gameServer.RespondsToPublicQuery = reader.GetNullableValue<bool>("RespondsToPublicQuery"); 
            gameServer.PingFailedCount = reader.GetInt32(reader.GetOrdinal("PingFailedCount"));
            gameServer.DatePublicQueryLastChecked = reader.GetNullableValue<DateTime>("DatePublicQueryLastChecked");
            gameServer.VerificationStatus = (EVerificationStatus)reader.GetByte(reader.GetOrdinal("VerificationStatus"));
            gameServer.QueryPort = reader.GetNullableValue<int>("QueryPort");
            gameServer.GameServerRatingID = reader.GetNullableValue<int>("GameServerRatingID");

            // GeoCoding
            int countryId = reader.GetNullableValue<int>("ManualCountryID");
            if (countryId == default(int))
            {
                IPAddress address = new IPAddress(gameServer.IPAddress);
                var countryIpRange = CountryIPRange.GetRange(address.ToInt64());
                if (countryIpRange != null)
                {
                    gameServer.CountryCode = countryIpRange.CountryCode;
                }
                else { gameServer.CountryCode = "Unknown"; }
            }
            else
            {
                gameServer.CountryCode = CountryCache.Instance.GetCountryCodeFromId(countryId);
            }

            // Add the players
            if (playerCache.ContainsKey(gameServer.ID))
            {
                gameServer.GameServerPlayers = playerCache[gameServer.ID];
            }

            var dataSource = GameServerDataSourceCache.Instance.GetByID(gameServer.GameServerDataSourceID);
            if (dataSource != null)
            {
                // Add the game properties
                gameServer.GameID = dataSource.GameID;
                var game = GameCache.Instance.GetGameByID(gameServer.GameID);
                if (game != null)
                {
                    gameServer.GameSlug = game.Slug;
                }


                if (pluginsByServerID.ContainsKey(gameServer.ID))
                {
                    IEnumerable<int> pluginIDs = pluginsByServerID[gameServer.ID];
                    foreach (var pluginID in pluginIDs)
                    {
                        CGameServerPlugin plugin = null;
                        if (dataSource.GameServerPluginsByID.TryGetValue(pluginID, out plugin))
                        {
                            gameServer.GameServerPlugins.Add(plugin);
                        }                        
                    }
                }              
            }

            //Add the game Properties
            if (gameProperties.ContainsKey(gameServer.ID))
            {
                gameServer.GameServerProperties = gameProperties[gameServer.ID];
            }

            // Add the Game Server Tags
            if (gameServerTags.ContainsKey(gameServer.ID))
            {
                gameServer.GameServerTags = gameServerTags[gameServer.ID];
            }

            //Add the GameServer Rating
            if (gameServerRatings.Any(p => p.ID == gameServer.GameServerRatingID))
            {
                gameServer.GameServerRating = gameServerRatings.FirstOrDefault(p => p.ID == gameServer.GameServerRatingID);
            }
        }

        public static CServiceResponse Claim(this CGameServer gameServer, int userId)
        {
            return new CServiceResponse(EServiceResponseStatus.Successful);
        }        
    }
}