﻿using System;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.GameServers.Extensions
{
    public static class CGameServerRatingExtensions
    {
        public static void SetFromDataReader(this CGameServerRating rating, SqlDataReader reader)
        {
            rating.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            rating.Title = reader.GetString(reader.GetOrdinal("Title"));
            rating.Description = reader.GetNullableValue<string>("Description");
            rating.Status = (EGameServerRatingStatus)reader.GetByte(reader.GetOrdinal("Status"));
        }
    }
}