﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.SqlClient;
using System.Net;
using System.Diagnostics;

namespace Curse.GameServers.Geocoding
{
    public class CountryIPRange
    {
        public Int64 Start { get; set; }
        public Int64 End { get; set; }
        public string CountryCode { get; set; }

        private static Dictionary<Int64, CountryIPRange> _values;
        private static Int64[] _binarySearchIndex;

        public CountryIPRange(SqlDataReader reader)
        {
            CountryCode = (string)reader["CountryCode"];
            Start = (Int64)reader["IPRangeStart"];
            End = (Int64)reader["IPRangeEnd"];
        }

        public static void BuildRanges(IEnumerable<CountryIPRange> ranges)
        {
            _values = new Dictionary<Int64, CountryIPRange>();

            foreach (var item in ranges)
            {
                _values[item.Start] = item;
            }

            _binarySearchIndex = _values.Keys.ToArray();

            Array.Sort(_binarySearchIndex);
        }

        public static CountryIPRange GetRange(Int64 value)
        {
            DateTime startDateTime = DateTime.Now;

            int searchIndex = Array.BinarySearch(_binarySearchIndex, value);
            if (searchIndex < 0)
                searchIndex = ~searchIndex - 1;
            if (searchIndex < 0)
                return null;
            CountryIPRange proposedRange = _values[_binarySearchIndex[searchIndex]];            

            if (proposedRange.End >= value)
            {
                return proposedRange;
            }
            else
            {
                return null;
            }
        }
    }
}