﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles OS details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class OS
        : IPackable
    {
        public UInt32 MajorVersion = 0;
        public UInt32 MinorVersion = 0;
        public UInt32 BuildVersion = 0;
        public UInt32 PlatformId = 0;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(MajorVersion) &&
                   pBuf.Write(MinorVersion) &&
                   pBuf.Write(BuildVersion) &&
                   pBuf.Write(PlatformId);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref MajorVersion) &&
                   pBuf.Read(ref MinorVersion) &&
                   pBuf.Read(ref BuildVersion) &&
                   pBuf.Read(ref PlatformId);

        }
    }
}
