﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles RAM details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class RAM
        : IPackable
    {
        public UInt64 SizeFree = 0;
        public UInt64 SizeTotal = 0;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(SizeFree) &&
                   pBuf.Write(SizeTotal);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref SizeFree) &&
                   pBuf.Read(ref SizeTotal);

        }
    }
}
