﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles Sound details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class Sound
        : IPackable
    {
        public UInt32 Flags = 0;
        public UInt32 MinSecondarySampleRate = 0;
        public UInt32 MaxSecondarySampleRate = 0;
        public UInt32 PrimaryBuffers = 0;
        public UInt32 MaxHwMixingAllBuffers = 0;
        public UInt32 MaxHwMixingStaticBuffers = 0;
        public UInt32 MaxHwMixingStreamingBuffers = 0;
        public UInt32 FreeHwMixingAllBuffers = 0;
        public UInt32 FreeHwMixingStaticBuffers = 0;
        public UInt32 FreeHwMixingStreamingBuffers = 0;
        public UInt32 MaxHw3DAllBuffers = 0;
        public UInt32 MaxHw3DStaticBuffers = 0;
        public UInt32 MaxHw3DStreamingBuffers = 0;
        public UInt32 FreeHw3DAllBuffers = 0;
        public UInt32 FreeHw3DStaticBuffers = 0;
        public UInt32 FreeHw3DStreamingBuffers = 0;
        public UInt32 TotalHwMemBytes = 0;
        public UInt32 FreeHwMemBytes = 0;
        public UInt32 MaxContigFreeHwMemBytes = 0;
        public UInt32 UnlockTransferRateHwBuffers = 0;
        public UInt32 PlayCpuOverheadSwBuffers = 0;
        public String Description = null;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Flags) &&
                   pBuf.Write(MinSecondarySampleRate) &&
                   pBuf.Write(MaxSecondarySampleRate) &&
                   pBuf.Write(PrimaryBuffers) &&
                   pBuf.Write(MaxHwMixingAllBuffers) &&
                   pBuf.Write(MaxHwMixingStaticBuffers) &&
                   pBuf.Write(MaxHwMixingStreamingBuffers) &&
                   pBuf.Write(FreeHwMixingAllBuffers) &&
                   pBuf.Write(FreeHwMixingStaticBuffers) &&
                   pBuf.Write(FreeHwMixingStreamingBuffers) &&
                   pBuf.Write(MaxHw3DAllBuffers) &&
                   pBuf.Write(MaxHw3DStaticBuffers) &&
                   pBuf.Write(MaxHw3DStreamingBuffers) &&
                   pBuf.Write(FreeHw3DAllBuffers) &&
                   pBuf.Write(FreeHw3DStaticBuffers) &&
                   pBuf.Write(FreeHw3DStreamingBuffers) &&
                   pBuf.Write(TotalHwMemBytes) &&
                   pBuf.Write(FreeHwMemBytes) &&
                   pBuf.Write(MaxContigFreeHwMemBytes) &&
                   pBuf.Write(UnlockTransferRateHwBuffers) &&
                   pBuf.Write(PlayCpuOverheadSwBuffers) &&
                   pBuf.Write(Description);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Flags) &&
                   pBuf.Read(ref MinSecondarySampleRate) &&
                   pBuf.Read(ref MaxSecondarySampleRate) &&
                   pBuf.Read(ref PrimaryBuffers) &&
                   pBuf.Read(ref MaxHwMixingAllBuffers) &&
                   pBuf.Read(ref MaxHwMixingStaticBuffers) &&
                   pBuf.Read(ref MaxHwMixingStreamingBuffers) &&
                   pBuf.Read(ref FreeHwMixingAllBuffers) &&
                   pBuf.Read(ref FreeHwMixingStaticBuffers) &&
                   pBuf.Read(ref FreeHwMixingStreamingBuffers) &&
                   pBuf.Read(ref MaxHw3DAllBuffers) &&
                   pBuf.Read(ref MaxHw3DStaticBuffers) &&
                   pBuf.Read(ref MaxHw3DStreamingBuffers) &&
                   pBuf.Read(ref FreeHw3DAllBuffers) &&
                   pBuf.Read(ref FreeHw3DStaticBuffers) &&
                   pBuf.Read(ref FreeHw3DStreamingBuffers) &&
                   pBuf.Read(ref TotalHwMemBytes) &&
                   pBuf.Read(ref FreeHwMemBytes) &&
                   pBuf.Read(ref MaxContigFreeHwMemBytes) &&
                   pBuf.Read(ref UnlockTransferRateHwBuffers) &&
                   pBuf.Read(ref PlayCpuOverheadSwBuffers) &&
                   pBuf.Read(ref Description);
        }
    }
}
