﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace HardwareCenter
{
    /**
     * Handles Update details for transmission
     *
     * @author Shane Bryldt
     */
    public sealed class Update
        : IPackable
    {
        public CPU CPU = new CPU();
        public PackableList<GPU> GPUs = new PackableList<GPU>();
        public PackableList<HD> HDs = new PackableList<HD>();
        public RAM RAM = new RAM();
        public OS OS = new OS();
        public Sound Sound = new Sound();
        public Display Display = new Display();
        public bool IsLaptop = false;

        /**
         * Implements IPackable Write
         * 
         * @param  pBuf  the buffer accessed using IWritable
         * @return       true if all the data was written, false otherwise
         */
        public Boolean Write(IWriteable pBuf)
        {
            return CPU.Write(pBuf) &&
                   GPUs.Write(pBuf) &&
                   HDs.Write(pBuf) &&
                   RAM.Write(pBuf) &&
                   OS.Write(pBuf) &&
                   Sound.Write(pBuf) &&
                   Display.Write(pBuf);
        }

        /**
         * Implements IPackable Read
         * 
         * @param  pBuf  the buffer accessed using IReadable
         * @return       true if all the data was read, false otherwise
         */
        public Boolean Read(IReadable pBuf)
        {
            return CPU.Read(pBuf) &&
                   GPUs.Read(pBuf) &&
                   HDs.Read(pBuf) &&
                   RAM.Read(pBuf) &&
                   OS.Read(pBuf) &&
                   Sound.Read(pBuf) &&
                   Display.Read(pBuf) &&
                   pBuf.Read(ref IsLaptop);
        }
   }
}
