﻿using System.Configuration;


namespace LogFileErrorMonitor
{
    public class ReporterConfiguration : ConfigurationSection
    {
        private static ReporterConfiguration _instance = ConfigurationManager.GetSection("ConsoleAppsToScan") as ReporterConfiguration;
        public static ReporterConfiguration Instance
        {
            get
            {
                return _instance;
            }
        }

        public ReporterConfiguration() { }


        [ConfigurationProperty("ConsoleApps", IsRequired = true)]
        public ConsoleAppsConfigCollection _ConsoleAppsConfig
        {
            get { return this["ConsoleApps"] as ConsoleAppsConfigCollection; }
        }
    }

    public class ConsoleAppsConfigCollection : ConfigurationElementCollection
    {
        public ConsoleAppConfigElement this[int index]
        {
            get
            {
                return base.BaseGet(index) as ConsoleAppConfigElement;
            }
            set
            {
                if (base.BaseGet(index) != null)
                {
                    base.BaseRemoveAt(index);
                }
                this.BaseAdd(index, value);
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new ConsoleAppConfigElement();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((ConsoleAppConfigElement)element).Name;
        }
    }

    public class ConsoleAppConfigElement : ConfigurationElement
    {
        public ConsoleAppConfigElement() { }

        [ConfigurationProperty("name", IsRequired = true)]
        public string Name
        {
            get
            {
                return (string)this["name"];
            }
            set
            {
                this["name"] = value;
            }
        }

        [ConfigurationProperty("path", IsRequired = true)]
        public string Path
        {
            get
            {
                return (string)this["path"];
            }
            set
            {
                this["path"] = value;
            }
        }

        [ConfigurationProperty("limitRegex", IsRequired = true)]
        public string LimitRegex
        {
            get
            {
                return (string)this["limitRegex"];
            }
            set
            {
                this["limitRegex"] = value;
            }
        }

        [ConfigurationProperty("limitSize", IsRequired = true)]
        public string LimitSize
        {
            get
            {
                return (string)this["limitSize"];
            }
            set
            {
                this["limitSize"] = value;
            }
        }

        [ConfigurationProperty("sendEmailTo", IsRequired = true)]
        public string SendEmailTo
        {
            get
            {
                return (string)this["sendEmailTo"];
            }
            set
            {
                this["sendEmailTo"] = value;
            }
        }
    }
}