﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace MonitoringService
{
    [ServiceContract]
    public interface IService
    {

        [OperationContract]
        ServiceResponse UpdateApplicationStatus(ApplicationStatus _applicationStatus);

        [OperationContract]
        [WebInvoke(Method = "GET",
           ResponseFormat = WebMessageFormat.Json,
           BodyStyle = WebMessageBodyStyle.Wrapped,
           UriTemplate = "getstatus/{applicationName}/{intervalCheck}")]
        string GetApplicationStatus(string applicationName, string intervalCheck);

        [OperationContract]
        [WebInvoke(Method = "GET",
           ResponseFormat = WebMessageFormat.Json,
           BodyStyle = WebMessageBodyStyle.Wrapped,
           UriTemplate = "gethealth/{applicationName}/{intervalCheck}")]
        string GetApplicationHealth(string applicationName, string intervalCheck);

        [OperationContract]
        [WebInvoke(Method = "GET",
           ResponseFormat = WebMessageFormat.Json,
           BodyStyle = WebMessageBodyStyle.Wrapped,
           UriTemplate = "health-check")]
        string HealthCheck();

    }

    /// <summary>
    /// ApplicaitonStatus object that is updated when passed from the client application
    /// to the UpdateApplicationStatus method
    /// </summary>
    [DataContract]
    public class ApplicationStatus
    {
        private string _applicationName;
        [DataMember]
        public string ApplicationName
        {
            get { return _applicationName; }
            set { _applicationName = value; }
        }

        private DateTime _statusUpdateTime;
        [DataMember]
        public DateTime StatusUpdateTime
        {
            get { return _statusUpdateTime; }
            set { _statusUpdateTime = value; }
        }

        private string _statusMessage;
        [DataMember]
        public string StatusMessage
        {
            get { return _statusMessage; }
            set { _statusMessage = value; }
        }

        private string _apiKey;
        [DataMember]
        public string ApiKey
        {
            get { return _apiKey; }
            set { _apiKey = value; }
        }

    }

    /// <summary>
    /// ServiceResponse object that updates the client with a status sucessful
    /// or status failed response message from the UdpateApplicationStatus method
    /// </summary>
    [DataContract]
    public class ServiceResponse
    {
        private ServiceResponseType _responseMessage;
        [DataMember]
        public ServiceResponseType ResponseMessage
        {
          get { return _responseMessage; }
          set { _responseMessage = value; }
        }


        private Exception _exception;
        [DataMember]
        public Exception Exception
        {
          get { return _exception; }
          set { _exception = value; }
        }

    }
}
