﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Data.SqlClient;

namespace MonitoringService
{
    public class MonitorService : IService
    {
        /// <summary>
        /// This method is used to create or update an Applicaitons Status datetime stamp
        /// </summary>
        /// <param name="_applicationStatus">ApplicationStatus DataContract</param>
        /// <returns>ServiceResponse status message</returns>
        public ServiceResponse UpdateApplicationStatus(ApplicationStatus _applicationStatus)
        {
            ServiceResponse _response = new ServiceResponse();

            if (_applicationStatus.ApiKey == "1bc38eeadf533dc48fddf238f57388fe")
            {

                using (SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["CobaltConnectionString"].ToString()))
                {
                    string strSQL = "dbo.UpdateApplicationStatus";
                    SqlCommand com = new SqlCommand(strSQL, conn);
                    com.CommandType = System.Data.CommandType.StoredProcedure;
                    com.Parameters.AddWithValue("@ApplicationName", _applicationStatus.ApplicationName);
                    com.Parameters.AddWithValue("@StatusMessage", _applicationStatus.StatusMessage);
                    com.Parameters.AddWithValue("@StatusUpdateTime", _applicationStatus.StatusUpdateTime);
                    conn.Open();
                    try
                    {
                        com.ExecuteNonQuery();
                        _response.ResponseMessage = ServiceResponseType.Successful;
                        _response.Exception = null;
                    }
                    catch (Exception ex)
                    {
                        _response.ResponseMessage = ServiceResponseType.Failed;
                        _response.Exception = ex;
                    }
                    finally
                    {
                        conn.Close();
                    }
                    conn.Close();

                }

                return _response;
            }
            else
            {
                _response.ResponseMessage = ServiceResponseType.Failed;
                return _response;
            }

        }

        /// <summary>
        /// This method is called via rest and displays a JSON message of Offline or Online based
        /// </summary>
        /// <param name="_applicationName">name of client being monitored</param>
        /// <returns>string of Offline or Online</returns>
        public string GetApplicationStatus(string applicationName, string checkInterval)
        {
            string _status = "Offline";
            int _interval = 5;

            try
            {
                _interval = Convert.ToInt32(checkInterval);
            }
            catch
            {
                _status = "Improper check interval format. Must be able to convert to an integer.";
            }

            if (_status == "Offline")
            {
                using (SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["CobaltConnectionString"].ToString()))
                {
                    string strSQL = "dbo.GetApplicationStatus";
                    SqlCommand com = new SqlCommand(strSQL, conn);
                    com.CommandType = System.Data.CommandType.StoredProcedure;
                    com.Parameters.AddWithValue("@ApplicationName", applicationName);
                    conn.Open();
                    try
                    {
                        DateTime dt = (DateTime)com.ExecuteScalar();
                        if (DateTime.UtcNow < dt.AddMinutes(_interval))
                        {
                            _status = "Online";
                        }

                    }
                    catch (Exception ex)
                    {
                        _status = "Could not execute database query";
                    }
                    finally
                    {
                        conn.Close();
                    }
                    conn.Close();

                }
            }

            return _status;
        }

        /// <summary>
        /// This method will return the StatusMessage column for a row, based on the ApplicationName. This allows us to monitor other aspects
        /// of an application beyind it simply crashing. For instance, the application may be running, but generating a lot of errors, as 
        /// as such would be in an unhealthy state.
        /// </summary>
        /// <param name="applicationName">name of application being monitored</param>
        /// <returns>a string message set by the monitored app</returns>
        public string GetApplicationHealth(string applicationName, string checkInterval)
        {
            string health = "Unhealthy - default message";
            int _interval = 5;

            try
            {
                _interval = Convert.ToInt32(checkInterval);
            }
            catch
            {
                health = "Unhealthy - Improper check interval format. Must be able to convert to an integer.";
            }

            DateTime healthDate = System.DateTime.Now;

            using (SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["CobaltConnectionString"].ToString()))
            {
                string strSQL = "dbo.GetApplicationHealth";
                SqlCommand com = new SqlCommand(strSQL, conn);
                com.CommandType = System.Data.CommandType.StoredProcedure;
                com.Parameters.AddWithValue("@ApplicationName", applicationName);
                conn.Open();
                try
                {

                    using (SqlDataReader reader = com.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            health = reader.GetString(0);
                            healthDate = reader.GetDateTime(1);
                        }
                    }

                    if (DateTime.UtcNow > healthDate.AddMinutes(_interval))
                    {
                        health = "Unhealthy - Status has not been updated within time interval";
                    }

                    
                }
                catch (Exception ex)
                {
                    health = "Unhealthy - Could not execute database query on ApplicationMonitor DB";
                }
                finally
                {
                    conn.Close();
                }
                conn.Close();

            }
            return health;
        }

        public string HealthCheck()
        {
            using (SqlConnection conn = new SqlConnection(System.Configuration.ConfigurationManager.ConnectionStrings["CobaltConnectionString"].ToString()))
            {
                conn.Open();
            }

            return "Success";
        }
}
}
