﻿using System;
using System.Data;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using Curse;
using Curse.Logging;


namespace PaymentService
{
    [Serializable]
    public class CompedSubscription
    {
        public Int32 Id = 0;
        public Int32 UserId = 0;
        public DateTime DateCreated;

        public CompedSubscription()
        {
            
        }

        public CompedSubscription(Int32 pId, Int32 pUserId, DateTime pDateCreated)
        {
            Id = pId;
            UserId = pUserId;
            DateCreated = pDateCreated;
        }

        public static CompedSubscription CreateCompedSubscription(Int32 userId, int months)
        {

            CompedSubscription existingComp = GetExistingComp(userId);

            if (existingComp != null) return existingComp;

            if (existingComp == null)
            {
                using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["PaymentDB"].ConnectionString))
                {
                    conn.Open();

                    SqlCommand cmd = conn.CreateCommand();
                    cmd.Transaction = conn.BeginTransaction();
                    try
                    {

                        cmd.CommandText = "insert into comped_subscription(user_id, date_created) output inserted.id, inserted.user_id, inserted.date_created values(@user_id, @date_created)";
                        cmd.Parameters.Add(new SqlParameter("@user_id", userId));
                        cmd.Parameters.Add(new SqlParameter("@date_created", DateTime.UtcNow));
                        SqlDataReader rdr = cmd.ExecuteReader();
                        if (rdr.Read())
                        {
                            existingComp = new CompedSubscription(rdr.GetInt32(0), rdr.GetInt32(1), rdr.GetDateTime(2));
                            
                        }
                        rdr.Close();
                        cmd.Transaction.Commit();

                    }
                    catch (Exception ex)
                    {
                        Logger.Error("Create Comped Subscription: ");
                        cmd.Transaction.Rollback();
                        return null;
                    }
                }
            }
            return existingComp;
        }

        private static CompedSubscription GetExistingComp(int pUserId)
        {
            CompedSubscription comp = null;

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["PaymentDB"].ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select id, user_id, date_created from comped_subscription where user_id = " + pUserId.ToString();
                SqlDataReader rdr = cmd.ExecuteReader();
                if (rdr.Read())
                {
                    comp = new CompedSubscription(rdr.GetInt32(0), rdr.GetInt32(1), rdr.GetDateTime(2));
                }
            }
            return comp;

        }
    }
}
