using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.services;
using com.paypal.sdk.util;

namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for DoCapture.
	/// </summary>
	public class DoCapture : Page
	{
		protected HtmlTextArea note;
		protected HtmlInputText invoice_id;
		protected HtmlInputText amount;
		protected HtmlSelect currency;
		protected HtmlInputText authorization_id;
		protected System.Web.UI.HtmlControls.HtmlInputButton Submit;
		protected HtmlSelect CompleteCodeType;

		private void Page_Load(object sender, EventArgs e)
		{
			if (Request.QueryString.Get("TRANSACTIONID") != null)
				authorization_id.Value = Request.QueryString.Get("TRANSACTIONID");
			if (Request.QueryString.Get("AMT") != null)
				amount.Value = Request.QueryString.Get("AMT");
		}

		#region Web Form Designer generated code

		protected override void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Submit.ServerClick += new System.EventHandler(this.Submit_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}

		#endregion

		private void Submit_ServerClick(object sender, EventArgs e)
		{
			NVPCallerServices caller = PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder = new NVPCodec();
			encoder["METHOD"] = "DoCapture";
			encoder["TRXTYPE"] = "D";
			encoder["AUTHORIZATIONID"] = authorization_id.Value;
			encoder["COMPLETETYPE"] = CompleteCodeType.Value;
			encoder["AMT"] = amount.Value;
			if (!Utils.IsEmpty(invoice_id.Value))
				encoder["INVNUM"] = invoice_id.Value;
			encoder["NOTE"] = note.Value;


			string pStrrequestforNvp = encoder.Encode();
			string pStresponsenvp = caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"];
			if (strAck != null && (strAck == "Success" || strAck == "SuccessWithWarning"))
			{
				string pStrResQue = "AUTHORIZATIONID=" + decoder["AUTHORIZATIONID"] + "&" +
				                    //"PAYMENTSTATUS=" + decoder["PAYMENTSTATUS"] + "&" +
									"PAYMENTSTATUS=" + CompleteCodeType.Value + "&" +
				                    "AMT=" + decoder["AMT"] + "&" +
				                    "TRANSACTIONID=" + decoder["TRANSACTIONID"];

				Response.Redirect("DoCaptureReceipt.aspx?" + pStrResQue);
			}
			else
			{
				string pStrError = "ErrorCode=" + decoder["L_ERRORCODE0"] + "&" +
				                   "Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
				                   "Desc2=" + decoder["L_LONGMESSAGE0"];

				Response.Redirect("APIError.aspx?" + pStrError);
			}
		}
	}
}
