using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
using ASPDotNetSamples;
namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for DoDirectPayment.
	/// </summary>
	public class DoDirectPayment : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlInputText firstName;
		protected System.Web.UI.HtmlControls.HtmlInputText lastName;
		protected System.Web.UI.WebControls.DropDownList creditCardType;
		protected System.Web.UI.HtmlControls.HtmlInputText creditCardNumber;
		protected System.Web.UI.HtmlControls.HtmlSelect expdate_month;
		protected System.Web.UI.HtmlControls.HtmlSelect expdate_year;
		protected System.Web.UI.HtmlControls.HtmlInputText address1;
		protected System.Web.UI.HtmlControls.HtmlInputText address2;
		protected System.Web.UI.HtmlControls.HtmlInputText city;
		protected System.Web.UI.HtmlControls.HtmlSelect state;
		protected System.Web.UI.HtmlControls.HtmlInputText zip;
		protected System.Web.UI.HtmlControls.HtmlInputText amount;
		protected System.Web.UI.HtmlControls.HtmlSelect currency;
		protected System.Web.UI.HtmlControls.HtmlInputText cvv2Number;
		protected System.Web.UI.HtmlControls.HtmlInputText Text1;
		protected System.Web.UI.WebControls.Button PayButton;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.creditCardType.SelectedIndexChanged += new System.EventHandler(this.creditCardType_SelectedIndexChanged);
			this.PayButton.Click += new System.EventHandler(this.PayButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void PayButton_Click(object sender, System.EventArgs e)
		{

				com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
				NVPCodec encoder= new NVPCodec();
				encoder["METHOD"] =  "DoDirectPayment";
				encoder["PAYMENTACTION"] =  this.Request.QueryString[Constants.PAYMENT_TYPE_PARAM];
				encoder["AMT"] =  amount.Value;
				encoder["CREDITCARDTYPE"] =  creditCardType.SelectedItem.Value;		
				encoder["ACCT"] =  creditCardNumber.Value;						
				encoder["EXPDATE"] =  expdate_month.Value.ToString() +expdate_year.Value;
				encoder["CVV2"] =  cvv2Number.Value;
				encoder["FIRSTNAME"] =  firstName.Value;
				encoder["LASTNAME"] =  lastName.Value;										
				encoder["STREET"] =  address1.Value;
				encoder["CITY"] =  city.Value;	
				encoder["STATE"] =  state.Value;			
				encoder["ZIP"] =  zip.Value;	
				encoder["COUNTRYCODE"] =  "US";	
				encoder["CURRENCYCODE"] =  currency.Value;	

				string pStrrequestforNvp= encoder.Encode();
				string pStresponsenvp=caller.Call(pStrrequestforNvp);

				NVPCodec decoder = new NVPCodec();
				decoder.Decode(pStresponsenvp);

				string strAck = decoder["ACK"]; 
				if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
				{
					string pStrResQue=	"TRANSACTIONID="+ decoder["TRANSACTIONID"] + "&" +
						"AMT=" + decoder["AMT"] + "&" +
						"AVSCODE=" + decoder["AVSCODE"] + "&" +
						"CVV2MATCH=" +decoder["CVV2MATCH"] ;
						Response.Redirect("DoDirectPaymentReceipt.aspx?"+pStrResQue);
				}
				else
				{
					string pStrError=	"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
						"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
						"Desc2=" +decoder["L_LONGMESSAGE0"] ;

					Response.Redirect("APIError.aspx?"+pStrError);
				}
			
		}



		private void creditCardType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			creditCardNumber.Value=Util.GenerateCreditCardNumber(creditCardType.SelectedItem.Value);
		}
	}
}
