using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
using ASPDotNetSamples;


namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for DoReauthorization.
	/// </summary>
	public class DoReauthorization : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlInputText authorization_id;
		protected System.Web.UI.HtmlControls.HtmlInputText amount;
		protected System.Web.UI.HtmlControls.HtmlSelect CCode;
		protected System.Web.UI.HtmlControls.HtmlInputButton SubmitButton;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.SubmitButton.ServerClick += new System.EventHandler(this.SubmitButton_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SubmitButton_ServerClick(object sender, System.EventArgs e)
		{

			com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder= new NVPCodec();
			encoder["METHOD"] =  "DoReauthorization";
			encoder["AuthorizationID"] =  authorization_id.Value;
			encoder["AMT"] =  amount.Value;
			encoder["CURRENCYCODE"] =  CCode.Value;	

			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{
				string pStrResQue = "AUTHORIZATIONID=" + authorization_id.Value + "&" + 
					"AMT=" + amount.Value; 
				Response.Redirect("DoReauthorizationResponse.aspx?"+pStrResQue);
			}
			else
			{
				string pStrError=	"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
			}

		}
	}
}
