using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for GetExpressCheckoutDetails.
	/// </summary>
	public class GetExpressCheckoutDetails : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlInputHidden Street1;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Street2;
		protected System.Web.UI.HtmlControls.HtmlInputHidden City;
		protected System.Web.UI.HtmlControls.HtmlInputHidden State;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Code;
		protected System.Web.UI.HtmlControls.HtmlInputButton ECReceiptLink;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Country;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder= new NVPCodec();
			encoder["METHOD"] =  "GetExpressCheckoutDetails";
			encoder["TOKEN"] =  Session["TOKEN"].ToString();

			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);
			
			
			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{

			Session["PAYERID"]= decoder["PAYERID"];

			Street1.Value=decoder["SHIPTOSTREET"];
			Street2.Value=decoder["SHIPTOSTREET2"];
			City.Value=decoder["SHIPTOCITY"];
			State.Value=decoder["SHIPTOSTATE"];
			Code.Value =decoder["SHIPTOZIP"];
			Country.Value= decoder["SHIPTOCOUNTRYNAME"];
			
			}
			else
			{
				string pStrError=
					"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ECReceiptLink.ServerClick += new System.EventHandler(this.ECReceiptLink_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion


		private void ECReceiptLink_ServerClick(object sender, System.EventArgs e)
		{
			com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder= new NVPCodec();
			encoder["METHOD"] =  "DoExpressCheckoutPayment";
			encoder["TOKEN"] =  Session["TOKEN"].ToString();
			encoder["PAYERID"] =  Session["PAYERID"].ToString();
			encoder["AMT"] =  Request.QueryString["amount"];
			encoder["PAYMENTACTION"] =  Request.QueryString["paymentType"];
			encoder["CURRENCYCODE"] =  Request.QueryString["currency"];

			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);
			
			
			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{
				string pStrResQue=	"TRANSACTIONID="+ decoder["TRANSACTIONID"] + "&" +
					"CURRENCYCODE=" + decoder["CURRENCYCODE"] + "&" +
					"AMT=" +decoder["AMT"];
			
				Response.Redirect("DoExpressCheckoutPayment.aspx?"+pStrResQue);
			}
			else
			{
				string pStrError=
					"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
			}
		
		}
	}
}
