using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
using ASPDotNetSamples;


namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for MassPay.
	/// </summary>
	public class MassPay : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlInputText EmailSubject;
		protected System.Web.UI.HtmlControls.HtmlInputText ReceiverEmail1;
		protected System.Web.UI.HtmlControls.HtmlInputText ReceiverEmail2;
		protected System.Web.UI.HtmlControls.HtmlInputText ReceiverEmail3;
		protected System.Web.UI.HtmlControls.HtmlInputText UniqueID1;
		protected System.Web.UI.HtmlControls.HtmlInputText Note1;
		protected System.Web.UI.HtmlControls.HtmlInputText Note2;
		protected System.Web.UI.HtmlControls.HtmlInputText UniqueID2;
		protected System.Web.UI.HtmlControls.HtmlInputText UniqueID3;
		protected System.Web.UI.HtmlControls.HtmlInputButton SubmitButton;
		protected System.Web.UI.HtmlControls.HtmlInputText amount3;
		protected System.Web.UI.HtmlControls.HtmlInputText amount2;
		protected System.Web.UI.HtmlControls.HtmlInputText amount1;
		protected System.Web.UI.HtmlControls.HtmlInputText ReceiverType;
		protected System.Web.UI.HtmlControls.HtmlSelect CCode1;
		protected System.Web.UI.HtmlControls.HtmlInputText Note3;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.SubmitButton.ServerClick += new System.EventHandler(this.SubmitButton_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void SubmitButton_ServerClick(object sender, System.EventArgs e)
		{
			com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder= new NVPCodec();
			encoder["METHOD"] =  "MassPay";

			encoder["EMAILSUBJECT"] =  EmailSubject.Value;
			encoder["RECEIVERTYPE"] =  ReceiverType.Value;
			encoder["CURRENCYCODE"]=CCode1.Value;
			
			
			if(ReceiverEmail1.Value.Length>0)
			{
				encoder["L_EMAIL0"] =  ReceiverEmail1.Value;
				encoder["L_Amt0"] =  amount1.Value;
				encoder["L_UNIQUEID0"] =  UniqueID1.Value;
				encoder["L_NOTE0"] =  Note1.Value;
			}

			if(ReceiverEmail2.Value.Length>0)
			{
				encoder["L_EMAIL1"] =  ReceiverEmail2.Value;
				encoder["L_Amt1"] =  amount2.Value;
				encoder["L_UNIQUEID1"] =  UniqueID2.Value;
				encoder["L_NOTE1"] =  Note2.Value;
			}

			if(ReceiverEmail3.Value.Length>0)
			{
				encoder["L_EMAIL2"] =  ReceiverEmail3.Value;		
				encoder["L_Amt2"] =  amount3.Value;
				encoder["L_UNIQUEID2"] =  UniqueID3.Value;
				encoder["L_NOTE"] =   Note3.Value;
			}


			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{
				string pStrResQue = "AUTHORIZATIONID=" + decoder["AuthorizationID"] + "&" +
					"AMT=" + decoder["AMT"];
				Response.Redirect("MassPayResponse.aspx?"+pStrResQue);
			}
			else
			{
				string pStrError=	"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
			}

		}
	}
}
