using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for RefundTransaction.
	/// </summary>
	public class RefundTransaction : System.Web.UI.Page
	{
		protected System.Web.UI.HtmlControls.HtmlInputText transactionID;
		protected System.Web.UI.HtmlControls.HtmlSelect refundType;
		protected System.Web.UI.HtmlControls.HtmlInputText amount;
		protected System.Web.UI.HtmlControls.HtmlSelect currency;
		protected System.Web.UI.HtmlControls.HtmlTextArea memo;
		protected System.Web.UI.HtmlControls.HtmlInputButton Submit;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if(Request.QueryString.Get("TRANSACTIONID")!=null)
				transactionID.Value=Request.QueryString.Get("TRANSACTIONID");				
			if(Request.QueryString.Get("AMT")!=null)
				amount.Value=Request.QueryString.Get("AMT");	
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Submit.ServerClick += new System.EventHandler(this.Submit_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Submit_ServerClick(object sender, System.EventArgs e)
		{

				com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
				NVPCodec encoder= new NVPCodec();
				encoder["METHOD"] =  "RefundTransaction";
				encoder["TRANSACTIONID"] =  transactionID.Value;	
				if(refundType.Value!="Full")
				{
					encoder["AMT"] =  amount.Value;
					encoder["NOTE"] =  memo.Value;
				}
				encoder["REFUNDTYPE"] =  refundType.Value;
				
			
				string pStrrequestforNvp= encoder.Encode();
				string pStresponsenvp=caller.Call(pStrrequestforNvp);

				NVPCodec decoder = new NVPCodec();
				decoder.Decode(pStresponsenvp);
			
				string strAck = decoder["ACK"]; 
				if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
				{
					string pStrResQue=	"TRANSACTIONID=" + decoder["REFUNDTRANSACTIONID"] + "&" +
						"AMT=" + decoder["GROSSREFUNDAMT"];

					Response.Redirect("RefundReceipt.aspx?"+pStrResQue);
				}
				else
				{
					string pStrError=	"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
						"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
						"Desc2=" +decoder["L_LONGMESSAGE0"] ;

					Response.Redirect("APIError.aspx?"+pStrError);
				}

		}
	}
}
