using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for DoExpressCheckoutPayment.
	/// </summary>
	public class ReviewOrder : System.Web.UI.Page
	{
		private void Page_Load(object sender, System.EventArgs e)
		{

			
			string url=Request.Url.Scheme+ "://"+Request.Url.Host+":"+ Request.Url.Port+"/"; 
			
			

			string returnURL = url + ResolveUrl("GetExpressCheckoutDetails.aspx")+ "?amount=" +Request.QueryString["amount"] + "&currency=" + Request.QueryString["currency"] + "&paymentType="+ Request.QueryString["paymentType"];
			string cancelURL = url + ResolveUrl("SetExpressCheckout.aspx")+"?=paymentType=" + Request.QueryString["paymentType"] ;

			com.paypal.sdk.services.NVPCallerServices caller =PayPalAPI.PayPalAPIInitialize();
			NVPCodec encoder= new NVPCodec();
			encoder["METHOD"] =  "SetExpressCheckout";
			encoder["RETURNURL"] =  returnURL;
			encoder["CANCELURL"] =  cancelURL;	
			encoder["AMT"] =  Request.QueryString["amount"];
			encoder["PAYMENTACTION"] =  Request.QueryString["paymentType"];
			encoder["CURRENCYCODE"] =  Request.QueryString["currency"];	

			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{	
				Session["TOKEN"]= decoder["TOKEN"];
				//string ECURL=Constants.EC_URL+"&cmd=_express-checkout&token="+decoder["TOKEN"];
				string host = "www." + Constants.ENVIRONMENT + ".paypal.com";
				string ECURL="https://" + host + "/cgi-bin/webscr?cmd=_express-checkout&" + "&token="+ decoder["TOKEN"];
				Response.Redirect(ECURL);
				
			}
			else
			{
				string pStrError=
					"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
