using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using com.paypal.sdk.core;
using com.paypal.sdk.util;
namespace ASPDotNetSamples.AspNet
{
	/// <summary>
	/// Summary description for TransactionSearch.
	/// </summary>
	public class TransactionSearch : System.Web.UI.Page
	{

		protected System.Web.UI.HtmlControls.HtmlInputText transactionID;
		protected System.Web.UI.HtmlControls.HtmlInputText endDateStr;
		protected System.Web.UI.HtmlControls.HtmlInputText startDateStr;
		protected System.Web.UI.HtmlControls.HtmlInputText startDate;
		protected System.Web.UI.HtmlControls.HtmlInputText endDate;
		protected System.Web.UI.HtmlControls.HtmlInputButton Submit;
		
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!this.IsPostBack)
			{
				startDateStr.Value=DateTime.Now.AddDays(-1).ToShortDateString().Replace("/","-");
				endDateStr.Value=DateTime.Now.ToShortDateString().Replace("/","-");
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Submit.ServerClick += new System.EventHandler(this.Submit_ServerClick);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion



		private void Submit_ServerClick(object sender, System.EventArgs e)
		{
			com.paypal.sdk.services.NVPCallerServices caller = new com.paypal.sdk.services.NVPCallerServices();
			caller.APIProfile = SetProfile.SessionProfile;

			NVPCodec encoder= new NVPCodec();

			DateTime date;

			encoder["METHOD"] =  "TransactionSearch";
			encoder["TRXTYPE"] =  "Q"; //Date format from server 2006-9-6T0:0:0
			
			date=DateTime.Parse(startDateStr.Value);
			encoder["STARTDATE"] =  date.Year+"-"+date.Month+"-"+date.Day+"T0:0:0";

			if(endDateStr.Value.Length>0)
			{
				date=DateTime.Parse(endDateStr.Value);
				encoder["ENDDATE"] =  date.Year+"-"+date.Month+"-"+date.Day+"T23:59:59";
			}


			if (transactionID.Value.Length>0)
			{
				encoder["TRANSACTIONID"] =  transactionID.Value;
			}


			string pStrrequestforNvp= encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{
				if (decoder["L_TRANSACTIONID0"]!=null && decoder["L_TRANSACTIONID0"].Length>0)
				{
					string pStrResQue="TRANSACTIONID="+ decoder["TRANSACTIONID"] + "," +

						"AMT=" + decoder["AMT"] + "," +

						"AVSCODE=" + decoder["AVSCODE"] + "," +

						"CVV2MATCH=" +decoder["CVV2MATCH"];

					Session["NVPResp"]=decoder;
					Response.Redirect("TransactionSearchResults.aspx?"+pStrResQue);
				}
				else
				{
					Response.Write("Your search did not match any transactions!");
				}
			}
			else
			{
				string pStrError=

					"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +

					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +

					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				Response.Redirect("APIError.aspx?"+pStrError);
				
				
			}
		}
	}
}
