	using System.Runtime.InteropServices;
	using com.paypal.sdk.logging;

	/// <summary>
	/// PayPal SOAP handler attribute
	/// </summary>
	[AttributeUsage(AttributeTargets.Method)]
	public class DefaultSOAPHandlerAttribute : SoapExtensionAttribute
	{
		/// <summary>
		/// Gets the Type of the SOAP extension
		/// </summary>
		public override Type ExtensionType
		{
			get {return typeof(DefaultSOAPHandler); }
		}
			
		/// <summary>
		/// Gets or set the priority of the SOAP extension
		/// </summary>
		public override int Priority
		{
			get {return 1;}
			set {}
		}
	}
