//#if NVP
/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

namespace com.paypal.sdk.core
{
	/// <summary>
	/// Factory class which makes new profile objects
	/// </summary>
	public class APICallerFactory 
	{




#if NVP
		/// <summary>
		/// Create an INVPAPICaller object
		/// </summary>
		/// <returns>APICallerBase</returns>
		public static APICallerBase createNVPAPICaller() 
		{
			return new nvp.NVPAPICaller();
		} // createNVPAPICaller
#else
		/// <summary>
		/// Created an SOAPAPICaller object
		/// </summary>
		/// <returns>APICallerBase </returns>
		public static APICallerBase createSOAPAPICaller() 
		{
			return new  soap.SOAPAPICaller();
		} // createSOAPAPICaller
#endif
	} // APICallerFactory
} // profiles namespace
//#endif