/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

using System;

using log4net;

namespace com.paypal.sdk.exceptions
{
	/// <summary>
	/// Exception that causes the SDK to cease functioning properly
	/// </summary>
	public class FatalException : PayPalException
	{
		private static ILog log = LogManager.GetLogger("com.paypal.sdk.exceptions.FatalException"); 

		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		public FatalException() : base() {}


		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		public FatalException(string message) : base(message)
		{
			if (log.IsFatalEnabled) 
			{
				log.Fatal(message, this);
			}
		}


		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		/// <param name="cause">The exception that is the cause of the current exception</param>
		public FatalException(string message, Exception cause) : base(message, cause)
		{
			if (log.IsFatalEnabled) 
			{
				log.Fatal(message, cause);
			}
		}
	} // FatalException
} // exceptions namespace