/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

using System;

using log4net;

namespace com.paypal.sdk.exceptions
{
	/// <summary>
	/// Exception that occurs within the context of a transaction 
	/// </summary>
	public class TransactionException : PayPalException
	{
		private static ILog log = LogManager.GetLogger("com.paypal.sdk.exceptions.TransactionException"); 

		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		public TransactionException() : base()
		{}


		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		public TransactionException(string message): base(message)
		{
			if (log.IsErrorEnabled)
			{
				log.Error(message, this);
			}
		}


		/// <summary>
		/// Represents errors that occur during application execution
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		/// <param name="cause">The exception that is the cause of the current exception</param>
		public TransactionException(string message, Exception cause): base(message, cause)
		{
			if (log.IsErrorEnabled) 
			{
				log.Error(message, this);
			}
		}
	} // TransactionException
} // exceptions namespace