/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

using System;

using log4net;

namespace com.paypal.sdk.exceptions
{
	/// <summary>
	/// SDK Warning
	/// </summary>
	public class WarningException:PayPalException
	{
		private static ILog log = LogManager.GetLogger("com.paypal.sdk.exceptions.WarningException"); 

		/// <summary>
		/// SDK Warning
		/// </summary>
		public WarningException() : base() {}


		/// <summary>
		/// SDK Warning
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		public WarningException(string message): base(message)
		{
			if (log.IsWarnEnabled)
			{
				log.Warn(message, this);
			}
		}


		/// <summary>
		/// SDK Warning
		/// </summary>
		/// <param name="message">The message that describes the error</param>
		/// <param name="cause">The exception that is the cause of the current exception</param>
		public WarningException(string message, Exception cause): base(message, cause)
		{
			if (log.IsWarnEnabled)
			{
				log.Warn(message, cause);
			}
		}
	} // WarningException class
} // exceptions namespace