/*
 * Copyright 2006 PayPal, Inc. All Rights Reserved.
 */

using System;
using com.paypal.sdk.exceptions;
using com.paypal.sdk.util;

namespace com.paypal.sdk.profiles
{
	/// <summary>
	/// CertificateAPIProfile implementation BaseAPIProfile and IAPIProfile
	/// </summary>
	[Serializable]
	public class CertificateAPIProfile : BaseAPIProfile
	{
		/// <summary>
		/// The certificate used to access the PayPal API
		/// </summary>
		private string certificateFile = string.Empty;

		/// <summary>
		/// The privateKeyPassword used
		/// </summary>
		private string privateKeyPassword = "";



		/// <summary>
		/// The file-name of the certificate to be used.
		/// Not implemented yet.
		/// </summary>
		public override string CertificateFile
		{
			get
			{
				return this.certificateFile;
			}
			set
			{
				this.certificateFile = value;
			}
		}

		/// <summary>
		/// API Signature used to access the PayPal API.  Only used for
		/// profiles set to Three-Token Authentication instead of Client-Side SSL Certificates.
		/// </summary>
		public override string APISignature
		{
			get
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
			set
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
		}

		/// <summary>
		/// The private key password
		/// </summary>
		public override string PrivateKeyPassword
		{
			get
			{
				return this.privateKeyPassword;
			}
			set
			{
				this.privateKeyPassword = value;
			}
		}
	} // CertificateAPIProfile
} // profiles namespace