/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

namespace com.paypal.sdk.profiles
{
	/// <summary>
	/// Public interface to the properties that encapsulate details of an entity that utilizes the PayPal SDK.
	/// </summary>
	public interface IAPIProfile
	{
		/// <summary>
		/// The username this profile uses to access the PayPal API
		/// </summary>
		string APIUsername { get; set; }

		/// <summary>
		/// The password this profile uses to access the PayPal API
		/// </summary>
		string APIPassword { get; set; }

		/// <summary>
		/// The signature hash used for three-token authentication
		/// </summary>
		string  APISignature { get; set; }

		/// <summary>
		/// The private key password
		/// </summary>
		string PrivateKeyPassword { get; set; }

		/// <summary>
		/// 
		/// </summary>
		string CertificateFile { get; set; }

		/// <summary>
		/// The name of the entity on behalf of which this profile is issuing calls
		/// </summary>
		string Subject { get; set; }


		/// <summary>
		///  The PayPal environment (Live, Sadnbox)
		/// </summary>
		string Environment { get; set; }


		/// <summary>
		///  The connection timeout in milliseconds
		/// </summary>
		int Timeout { get; set; }


		/// <summary>
		///  The maximum number of retries
		/// </summary>
		int MaximumRetries { get; set; }


		/// <summary>
		///  The delay time bewteen each retry call in milliseconds
		/// </summary>
		int DelayTime { get; set; }
	} // APIProfile
} // profiles namespace