/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

namespace com.paypal.sdk.profiles
{
	/// <summary>
	/// Factory class which makes new profile objects
	/// </summary>
	public class ProfileFactory 
	{
		/// <summary>
		/// Create an CreateSSLAPIProfile profile object
		/// </summary>
		/// <returns></returns>
		public static IAPIProfile createSSLAPIProfile() 
		{
			return (IAPIProfile) new  CertificateAPIProfile();
		} // CreateSSLAPIProfile


		/// <summary>
		/// Create an CreateSignatureAPIProfile profile object
		/// </summary>
		/// <returns></returns>
		public static IAPIProfile createSignatureAPIProfile() 
		{
			return (IAPIProfile) new SignatureAPIProfile();
		} // CreateSignatureAPIProfile



	} // ProfileFactory
} // profiles namespace