/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

using System;
using com.paypal.sdk.exceptions;
using com.paypal.sdk.util;

namespace com.paypal.sdk.profiles
{
	/// <summary>
	/// SignatureAPIProfile implementation BaseAPIProfile and IAPIProfile
	/// </summary>
	[Serializable]
	public class SignatureAPIProfile : BaseAPIProfile,IAPIProfile 
	{
		/// <summary>
		/// The API signature used in three-token authentication
		/// </summary>
		[NonSerialized] private string apiSignature;

		/// <summary>
		/// The file-name of the certificate to be used.  Returns error as this is Signature profile.
		/// </summary>
		public override string CertificateFile
		{
			get
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
			set
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
		}

		/// <summary>
		/// API Signature used to access the PayPal API.  Only used for
		/// profiles set to Three-Token Authentication instead of Client-Side SSL Certificates.
		/// </summary>
		public override string APISignature
		{
			get
			{
				return this.apiSignature;
			}
			set
			{
				this.apiSignature = value;
			}
		}

		/// <summary>
		/// The private key password. Returns error as this is Signature profile.
		/// </summary>
		public override string PrivateKeyPassword
		{
			get
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
			set
			{
				throw new FatalException(MessageResources.GetMessage("INVALID_PROFILE_OPERATION"));
			}
		}
	} // SignatureAPIProfile
} // profiles namespace