using System.IO;
using System.Reflection;
using com.paypal.sdk.util;

namespace com.paypal.sdk.resources
{
	/// <summary>
	/// Summary description for ResourceHelper.
	/// </summary>
	public class ResourceHelper
	{
		/// <summary>
		/// Reads an embedded resource within the assembly.
		/// </summary>
		/// <param name="name">The path to the resource without the Constants.RESOURCE_ROOT prepended</param>
		/// <returns>A stream to the resource</returns>
		public static Stream GetResourceStream(string name)
		{
			return Assembly.GetExecutingAssembly().GetManifestResourceStream(Constants.RESOURCE_ROOT + name);
		}
	}
}
