#if NVP
/*
 * Copyright 2005 PayPal, Inc. All Rights Reserved.
 */

using com.paypal.sdk.core;
using com.paypal.sdk.core.nvp;
using com.paypal.sdk.exceptions;
using com.paypal.sdk.profiles;
using com.paypal.sdk.util;

namespace com.paypal.sdk.services
{
	/// <summary>
	/// Facade class that implements API caller services
	/// </summary>
	public class NVPCallerServices
	{
		/// <summary>
		/// NVP API Caller reference makes actual NVP calls
		/// </summary>
		//private APICallerBase caller;
		private NVPAPICaller caller;
		
		/// <summary>
		/// Flag which determines whether or not this object has been initialized
		/// </summary>
		private bool initialized = false;
			
		/// <summary>
		/// Get/Set the API profile.
		/// </summary>
		public IAPIProfile APIProfile 
		{
			get 
			{
				return caller.Profile;
			}
			set
			{
				if (!initialized) 
				{
					this.Initialize();
				}
				caller.Profile = value;
			}
		}

		/// <summary>
		/// Initializes the object
		/// </summary>
		public void Initialize() 
		{
			//caller.Initialize();
			caller= (NVPAPICaller) APICallerFactory.createNVPAPICaller();
			initialized = true;
		}

		/// <summary>
		/// Caller Services
		/// </summary>
		/// <param name="requestnvp"></param>
		/// <returns></returns>
		public string Call(string requestnvp)
		{
						if (!initialized) 
						{
							this.Initialize();
						}

						if (requestnvp == null)
						{
							throw new TransactionException(MessageResources.GetMessage("INVALID_METHOD") + " : " + requestnvp);
						}
			
			string res=caller.Call(requestnvp);
			return res;
			
		}

	} // CallerServices
} // services namespace
#endif