#if NVP
/*
 * Copyright 2006 PayPal, Inc. All Rights Reserved.
 */

using System;
using com.paypal.sdk.profiles;
using com.paypal.sdk.services;

namespace com.paypal.sdk.util
{
	/// <summary>
	/// Summary description for NVPCodec.
	/// </summary>
	public class TestConnection
	{
		/// <summary>
		/// Testing the connection
		/// </summary>
		/// <param name="pProfile"></param>
		/// <returns></returns>
		public String testServerConnection(IAPIProfile pProfile) 
		{
			

			NVPCallerServices caller = new NVPCallerServices();
			caller.Initialize();
			caller.APIProfile=pProfile;
		
			NVPCodec encoder = new NVPCodec();	

			//Using TransactionSearch to test connection
			encoder["METHOD"] =  "TransactionSearch";
			encoder["TRXTYPE"] =  "Q"; //Date format from server 2006-9-6T0:0:0
			encoder["STARTDATE"] =  "1947-1-1T0:0:0";
			encoder["ENDDATE"] =  "1947-1-1T0:0:0";
			
			string pStrrequestforNvp=encoder.Encode();
			string pStresponsenvp=caller.Call(pStrrequestforNvp);

			NVPCodec decoder = new NVPCodec();
			decoder.Decode(pStresponsenvp);

			string strAck = decoder["ACK"]; 
			if(strAck !=null && (strAck=="Success" || strAck=="SuccessWithWarning"))
			{
					return  "Successfully Connected";
			}
			else
			{
				string pStrError=
					"ErrorCode="+ decoder["L_ERRORCODE0"] + "&" +
					"Desc=" + decoder["L_SHORTMESSAGE0"] + "&" +
					"Desc2=" +decoder["L_LONGMESSAGE0"] ;

				return pStrError;
			}

		}
																
	}
}
#endif