﻿
using System;
using System.Data;
using System.Configuration;
using System.Web;
using Curse.Auth;
using PaymentService.authservice;
namespace PaymentService
{
    
    

    public class PaymentAuth
    {
        private static readonly string AuthUrl = null;
        private static readonly int AuthSiteID = 0;
        
        static PaymentAuth()
        {
            AuthSiteID = Int32.Parse(ConfigurationManager.AppSettings["AuthenticationId"]);
            AuthUrl = ConfigurationManager.AppSettings["AuthenticationService"];

        }

        private static NetworkService GetClient()
        {
            return new NetworkService();
        }

        public static Boolean UserExists(Int32 pUserId)
        {
            var client = GetClient();
            return client.userIdExists(AuthSiteID, pUserId);
        }

        public static String GetUsername(Int32 pUserId)
        {
            var client = GetClient();
            return client.getUserNameFromUserId(AuthSiteID, pUserId);            
        }

        public static String GetUserEmail(Int32 pUserId)
        {
            var client = GetClient();
            return client.getUserEmailFromUserId(AuthSiteID, pUserId);
        }

        public static Boolean AddSubscriptionCredit(Int32 pUserId, Byte pMonths, Byte pLevel)
        {
            var client = GetClient();
            return client.addSubscriptionCredit(AuthSiteID, pUserId, pMonths, pLevel, (byte)ESubscriptionType.Premium);
        }

        public static Boolean CancelPremium(Int32 pUserId, DateTime pExpirationDate)
        {
            var client = GetClient();
            return client.cancelPremium(AuthSiteID, pUserId, pExpirationDate);
        }
    }
}
