﻿using System;
using System.Data;
using System.Globalization;

namespace PaymentService
{
    public class PaymentUtility
    {
        private const byte TIME_OFFSET_PST = 8;
        private const byte TIME_OFFSET_PDT = 7;

        public static DateTime ParseDateTime(string value)
        {
            string dateFormat = "HH:mm:ss MMM dd, yyyy";
            string timezone = null;
            if (value.Length > 4 && value[value.Length - 4] == ' ')
            {
                timezone = value.Substring(value.Length - 3, 3);
                dateFormat += " " + timezone;
            }
            DateTime parsedDate = DateTime.ParseExact(value, new string[] { dateFormat, "r", "u", "s", "U", "y" }, new CultureInfo("en-US", true), DateTimeStyles.None);
            switch(timezone)
            {
                case "PDT":
                    parsedDate = parsedDate.AddHours(TIME_OFFSET_PDT);
                    break;
                case "PST":
                    parsedDate = parsedDate.AddHours(TIME_OFFSET_PST);
                    break;
            }

            return parsedDate;
        }

    }
}
