﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

namespace PaymentService
{
    [Serializable()]
    public class SubscriptionType
    {
        public String Name = null;
        public Decimal Cost = 0;
        public Byte TermMonths = 0;
        public bool Recurring = false;

        private static readonly Dictionary<Int16, SubscriptionType> sSubscriptionTypes = new Dictionary<Int16, SubscriptionType>();

        public static SubscriptionType GetType(Int16 pTypeId)
        {
            
            if(sSubscriptionTypes.ContainsKey(pTypeId))
            {
                return sSubscriptionTypes[pTypeId];
            }
            else
            {
                return null;
            }
            
        }

        static SubscriptionType()
        {
            
            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["PaymentDB"].ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from subscription_type";
                using(SqlDataReader reader = cmd.ExecuteReader())
                {
                    while(reader.Read())
                    {
                        sSubscriptionTypes.Add(reader.GetInt16(reader.GetOrdinal("id")), new SubscriptionType(reader.GetString(reader.GetOrdinal("name")), reader.GetDecimal(reader.GetOrdinal("cost")), reader.GetByte(reader.GetOrdinal("term_months")), reader.GetBoolean(reader.GetOrdinal("is_recurring"))));
                    }
                }                
            }
            
        }

        public SubscriptionType()
        {
        }

        public SubscriptionType(String pName, Decimal pCost, Byte pTermMonths, bool recurring)
        {
            Name = pName;
            Cost = pCost;
            TermMonths = pTermMonths;
            Recurring = recurring;
        }

    }
}
