﻿using System;
using System.Data.SqlClient;
using System.Runtime.Serialization;

namespace Curse.RewardPointsService.Models
{
    [Serializable]
    [DataContract]
    public class MonthlyBudget
    {
        [DataMember]
        public int ID { get; set; }
        [DataMember]
        public DateTime MonthlyBudgetDate { get; set; }
        [DataMember]
        public DateTime DateCreated { get; set; }
        [DataMember]
        public DateTime DateModified { get; set; }
        [DataMember]
        public decimal PremiumBudget { get; set; }
        [DataMember]
        public decimal EstimatedPremiumBudget { get; set; }
        [DataMember]
        public decimal EcpmBudget { get; set; }
        [DataMember]
        public int EcpmDownloads { get; set; }
        [DataMember]
        public decimal EcpmImpressionsModifier { get; set; }
        [DataMember]
        public decimal EcpmRevenueModifier { get; set; }
        [DataMember]
        public decimal EcpmBudgetShareModifier { get; set; }
        [DataMember]
        public decimal PointExchangeRate { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            MonthlyBudgetDate = reader.GetDateTime(reader.GetOrdinal("MonthlyBudgetDate"));
            DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            DateModified = reader.GetDateTime(reader.GetOrdinal("DateModified"));
            PremiumBudget = reader.GetDecimal(reader.GetOrdinal("PremiumBudget"));
            EstimatedPremiumBudget = reader.GetDecimal(reader.GetOrdinal("EstimatedPremiumBudget"));
            EcpmBudget = reader.GetDecimal(reader.GetOrdinal("EcpmBudget"));
            EcpmDownloads = reader.GetInt32(reader.GetOrdinal("EcpmDownloads"));
            EcpmImpressionsModifier = reader.GetDecimal(reader.GetOrdinal("EcpmImpressionsModifier"));
            EcpmRevenueModifier = reader.GetDecimal(reader.GetOrdinal("EcpmRevenueModifier"));
            EcpmBudgetShareModifier = reader.GetDecimal(reader.GetOrdinal("EcpmBudgetShareModifier"));
            PointExchangeRate = reader.GetDecimal(reader.GetOrdinal("PointExchangeRate"));
        }
    }
}