﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Runtime.Serialization;
using Curse.RewardPointsService.Enums;
using Curse.ServiceModels.Configuration;

namespace Curse.RewardPointsService.Models
{
    [Serializable]
    [DataContract]
    public class Record
    {
        [DataMember]
        public int ID { get; set; }
        [DataMember]
        public int UserID { get; set; }
        [DataMember]
        public int OrderID { get; set; }
        [DataMember]
        public int TransferUserID { get; set; }
        [DataMember]
        public int DailyBudgetID { get; set; }
        [DataMember]
        public DateTime DateCreated { get; set; }
        [DataMember]
        public decimal PointChange { get; set; }
        [DataMember]
        public TransactionType Type { get; set; }
        [DataMember]
        public List<RecordGenerationBreakdown> Breakdowns  = new List<RecordGenerationBreakdown>();


        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            UserID = reader.GetInt32(reader.GetOrdinal("UserID"));
            OrderID = reader.IsDBNull(reader.GetOrdinal("OrderID"))? default(int): reader.GetInt32(reader.GetOrdinal("OrderID"));
            TransferUserID = reader.IsDBNull(reader.GetOrdinal("TransferUserID")) ? default(int) : reader.GetInt32(reader.GetOrdinal("TransferUserID"));
            DailyBudgetID = reader.IsDBNull(reader.GetOrdinal("DailyBudgetID")) ? default(int) : reader.GetInt32(reader.GetOrdinal("DailyBudgetID"));
            DateCreated = reader.GetDateTime(reader.GetOrdinal("DateCreated"));
            PointChange = reader.GetDecimal(reader.GetOrdinal("PointChange"));
            Type = (TransactionType)Enum.Parse(typeof(TransactionType), reader.GetByte(reader.GetOrdinal("Type")).ToString());

            if (Type == TransactionType.Generated)
            {
                using (var conn = new SqlConnection(DatabaseConfiguration.Instance["RewardPoints"].ConnectionString))
                {
                    using (var cmd = new SqlCommand("GetGenerationBreakdown"))
                    {
                        cmd.CommandType = CommandType.StoredProcedure;
                        cmd.Parameters.AddWithValue("@recordID", ID);
                        cmd.CommandTimeout = 120;
                        conn.Open();
                        cmd.Connection = conn;
                        using (var reader2 = cmd.ExecuteReader())
                        {
                            while (reader2.Read())
                            {
                                var recordGenerationBreakdown = new RecordGenerationBreakdown();
                                recordGenerationBreakdown.SetFromDataReader(reader2);
                                Breakdowns.Add(recordGenerationBreakdown);
                            }
                        }
                    }
                }
            }
        }
    }
}