﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Runtime.Serialization;
using System.Web;

namespace Curse.RewardPointsService.Models
{
    [Serializable]
    [DataContract]
    public class RecordGenerationBreakdown
    {
        [DataMember]
        public int ID { get; set; }
        [DataMember]
        public int ProjectID { get; set; }
        [DataMember]
        public int RecordID { get; set; }
        [DataMember]
        public decimal Points { get; set; }
        [DataMember]
        public string Name { get; set; }

        public void SetFromDataReader(SqlDataReader reader)
        {
            ID = reader.GetInt32(reader.GetOrdinal("ID"));
            ProjectID = reader.GetInt32(reader.GetOrdinal("ProjectID"));
            RecordID = reader.GetInt32(reader.GetOrdinal("RecordID"));
            Points = reader.GetDecimal(reader.GetOrdinal("Points"));
            Name = reader.GetString(reader.GetOrdinal("Name"));
        }
    }
}