﻿using System;
using System.Text.RegularExpressions;

namespace Curse.ROM
{
    public sealed class ClientVersion
         : IPackable
    {
        public Int32 Value = 0;
        public String Locale = "";
        public char[] dotSplit = { '.' };


        public Boolean Write(IWriteable pBuf)
        {
            return false;
        }

        public Boolean Read(IReadable pBuf)
        {
            String VersionString = null;
            if (!pBuf.Read(ref VersionString) || !VersionString.Contains(".") )
            {
                return false;
            }
            String[] parts = VersionString.Split(dotSplit);
            if (parts.Length < 2)
            {
                Value = 0;
                Locale = "";
                return false;
            }

            Value = Convert.ToInt32(parts[parts.Length - 2]);
            Locale = parts[parts.Length - 1];
            return true;
        }
    }
}
