﻿using Curse;
using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.ROM
{
    public class Update : IPackable
    {

        // Private Variables
        private Int64 mMinProfilerversion = 0;
        private Int32[] mSupportedClientVersions = null;
        private String[] mSupportedLocales = null;

        // Status
        public StatusCode UpdateStatus = StatusCode.Ok;
        public Int32 UserId = 0;
        public String UserHost = null;
        public bool IsTrustedUser = false;
        public bool IsSupportedLanguage = false;

        // Header Block
        public ClientVersion ClientVersion = new ClientVersion();
        public String ServerName = null;
        public String Language = "";
        public byte LanguageByte = 0;
        public Int32 ProfilerVersion = 0;

        // Error Block
        public PackableStringList Errors = new PackableStringList();


        // Data Block
        public PackableList<NPC> NPCs = new PackableList<NPC>();
        public PackableList<Quest> Quests = new PackableList<Quest>();
        public PackableList<StaticLocation> StaticLocs = new PackableList<StaticLocation>();
        public PackableList<Player> Players = new PackableList<Player>();
        public PackableList<Server> Servers = new PackableList<Server>();
        public PackableList<Guild> Guilds = new PackableList<Guild>();
        public PackableList<MallItem> MallItems = new PackableList<MallItem>();
        public PackableList<GameObject> GameObjects = new PackableList<GameObject>();


        public Boolean Write(IWriteable pBuf)
        {
            return true;
        }

        public Update(Int64 pMinProfilerVersion, Int32[] pSupportedClientVersions, String[] pSupportedLocales, Int32 pUserId, Boolean pIsTrustedUser)
        {
            mMinProfilerversion = pMinProfilerVersion;
            mSupportedClientVersions = pSupportedClientVersions;
            mSupportedLocales = pSupportedLocales;
            UserId = pUserId;
            IsTrustedUser = pIsTrustedUser;
        }

        public Boolean Read(IReadable pBuf)
        {
            Int16 padding = 0;
            byte languageId = 0;
            pBuf.Read(ref padding);
            bool headerStatus = pBuf.Read(ref ProfilerVersion) && ClientVersion.Read(pBuf) && pBuf.Read(ref ServerName);
            if(ClientVersion.Value == 0 || ClientVersion.Locale == "")
            {
                UpdateStatus = StatusCode.InvalidGameClientVersion;
                return false;
            }

            String[] langs = System.Enum.GetNames(typeof(ELocale));

            for(int i = 0;i<langs.Length;i++)
            {

                if (langs[i] == ClientVersion.Locale)
                {
                    LanguageByte = ((byte[])System.Enum.GetValues(typeof(ELocale)))[i];
                }
            }

            if (ServerName.Contains("|"))
            {
                ServerName = ServerName.Substring(0, ServerName.IndexOf("|"));
            }

            if (!headerStatus)
            {
                UpdateStatus = StatusCode.InvalidStream;
                return false;
            }

            if (ProfilerVersion < mMinProfilerversion)
            {
                UpdateStatus = StatusCode.InvalidProfilerVersion;
                return false;
            }

            if (Array.IndexOf(mSupportedClientVersions, ClientVersion.Value) == -1)
            {
                UpdateStatus = StatusCode.InvalidGameClientVersion;
                return false;
            }

            if (Array.IndexOf(mSupportedLocales, ClientVersion.Locale) >= 0)
            {
                IsSupportedLanguage = true;
            }

            /*bool errorStatus = Errors.Read(pBuf);
            if (!errorStatus)
            {
                return false;
            }

            if (Errors.Count > 0)
            {
                Logger.Log(ELogLevel.Error, UserHost, "LUA Errors: {0}", String.Join(Environment.NewLine, Errors.ToArray()));
                return false;
            }*/
            Language = ClientVersion.Locale;
            bool dataStatus = NPCs.Read(pBuf);
            dataStatus = dataStatus && Quests.Read(pBuf);
            dataStatus = dataStatus && StaticLocs.Read(pBuf);
            dataStatus = dataStatus && Players.Read(pBuf);
            dataStatus = dataStatus && Servers.Read(pBuf);
            dataStatus = dataStatus && Guilds.Read(pBuf);
            dataStatus = dataStatus && MallItems.Read(pBuf);
            //dataStatus = dataStatus && GameObjects.Read(pBuf);
            /*dataStatus = dataStatus && GameObjects.Read(pBuf);
            dataStatus = dataStatus && Items.Read(pBuf);
            dataStatus = dataStatus && ItemSets.Read(pBuf);
            dataStatus = dataStatus && Advances.Read(pBuf);
            dataStatus = dataStatus && Abilities.Read(pBuf);
            dataStatus = dataStatus && Influence.Read(pBuf);
            dataStatus = dataStatus && Quests.Read(pBuf);
            dataStatus = dataStatus && PublicQuests.Read(pBuf);
            dataStatus = dataStatus && IDMappings.Read(pBuf);
            dataStatus = dataStatus && Guilds.Read(pBuf);

            if (Guilds.Count > 0 && Guilds[0].Name.Value.Length == 0)
            {
                Guilds.Clear();
            }
            dataStatus = dataStatus && Players.Read(pBuf);
            dataStatus = dataStatus && LootHistory.Read(pBuf);

            if (ProfilerVersion >= 2008081800)
            {
                dataStatus = dataStatus && BattlefieldStatus.Read(pBuf);
                dataStatus = dataStatus && Talismans.Read(pBuf);
                dataStatus = dataStatus && Apothecary.Read(pBuf);
                dataStatus = dataStatus && Unlocks.Read(pBuf);
                dataStatus = dataStatus && BestiaryTasks.Read(pBuf);
                dataStatus = dataStatus && TomeFragments.Read(pBuf);
                dataStatus = dataStatus && Achievements.Read(pBuf);
                dataStatus = dataStatus && PvPLoots.Read(pBuf);
            }


            if (UserId > 1 && (ServerName == "Warpstone" || ServerName == "Deathsword"))
            {
                UpdateStatus = StatusCode.InvalidGameClientVersion;
                return false;
            }

            if (containsInvalidCharacters())
            {
                IsSupportedLanguage = false;
            }*/

            return dataStatus;

        }

        private bool containsInvalidCharacters()
        {
            

            return false;
        }

    }
}
