﻿using Curse;
using Curse.ROM;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace ROMDataService
{

    public static partial class DBNPCs
    {
        private const Byte NUM_BONUSES = 10;
        private const Byte NUM_CRAFTING_BONUSES = 25;

        private static Dictionary<CustomKey, Int32> sNPCNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sHistory =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sNPCConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sNPCLocationConfirmations =
    new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());



        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "posted", "posted_id", "version_id", "name" };
        private static String[] sIgnoreInsertColumns = { "id" };
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

        private static String sNPCLocationQueryFormat = "UPDATE npc_location SET " +
                                                        "total=total+1," +
                                                        "updated_id={0}," +
                                                        "updated=GETUTCDATE()" +
                                                        " WHERE npc_id={1} AND pos_x={4} AND pos_y = {5}" +
                                                        " IF @@ROWCOUNT = 0 " +
                                                        "INSERT INTO npc_location(" +
                                                        "npc_id,version_id,zone_id," +
                                                        "pos_x,pos_y,total,updated_id,posted_id) VALUES(" +
                                                        "{1},{2},{3},{4},{5},1,{0},{0});";

        private static String sNPCVendorQueryFormat = "UPDATE vendor set cost = {2}, type = {3} where npc_id = {0} and item_id = {1} IF @@ROWCOUNT = 0 insert into vendor (npc_id,item_id,cost,type) values({0},{1},{2},{3});";



        private static String sTempTableCreation = "SELECT TOP 0 * INTO #npc FROM npc;ALTER TABLE #npc DROP COLUMN id;ALTER TABLE #npc ADD id int;";

        private static DataTable sNpcUpdateSchema = null;
        private static DataTable sNpcInsertSchema = null;

        private static DataTable sNpcMerchandiseSchema = null;

        public static void Initialize()
        {
            sHistory.Clear();
            sNPCNameToId.Clear();

            foreach (String locale in DB.sLocalizations)
            {
                DB.PopulateNameToID(sNPCNameToId, "npc", locale);
            }
            DB.LoadSchema(ref sNpcUpdateSchema, "#npc", sTempTableCreation);
            DB.LoadSchema(ref sNpcInsertSchema, "npc");

            sInsertQuery = DB.GetInsertSQL(sNpcInsertSchema, sIgnoreInsertColumns);

            sUpdateCustomColumns.Add("min_level", "min_level=dbo.Lowest(npc.min_level,tmp.min_level)");
            sUpdateCustomColumns.Add("max_level", "max_level=dbo.Highest(npc.max_level,tmp.max_level)");



            sUpdateQuery = "update npc set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sNpcUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM npc,#npc tmp" +
                " WHERE npc.id=tmp.id;";

        }

        public static Int32 GetNpcId(String pNpcName, String pLocale)
        {
            return DB.GetIdFromName(sNPCNameToId, pNpcName, pLocale);
        }

        public static void AddNpc(String pNpcName, String pLocale, Int32 pNpcId)
        {
            DB.AddNameFromId(sNPCNameToId, pLocale, pNpcName, pNpcId);
        }

        private static void SetNPCLocationQuery(Int32 pNpcId, Update pUpdate, NPC pNpc, StringBuilder pBuilder)
        {
            // Locations
            foreach (EntityLocation location in pNpc.Locations)
            {

                if (location.X == 0 && location.Y == 0 && location.Zone == 0)
                {
                    continue;
                }

                CustomKey key = new CustomKey(pNpcId,
                                            location.Zone,
                                            location.X,
                                            location.Y);

                /*if (!DB.IsEntityConfirmed(sNPCLocationConfirmations,
                                key,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                pUpdate.IsTrustedUser))
                {
                    continue;
                }*/

                pBuilder.AppendFormat(sNPCLocationQueryFormat,
                    pUpdate.UserId,
                    pNpcId,
                    pUpdate.ClientVersion.Value,
                    location.Zone,
                    location.X,
                    location.Y);
            }

        }


 

        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.NPCs.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtInsert = sNpcUpdateSchema.Clone();
            DataTable dtUpdate = sNpcUpdateSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();
            SqlCommand cmd = pConn.CreateCommand();


            bool isNewRow = false;
            Int32 npcId = 0;
            foreach (NPC npc in pUpdate.NPCs)
            {


                npcId = GetNpcId(npc.Name, locale);
                if (npcId > 0)
                {
                    /*if (!DB.ReadyForDB(sHistory,
                                sNPCConfirmations,
                                npcId,
                                Config.Instance.NpcExpiration,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                (ELocale)pUpdate.Language,
                                pUpdate.IsTrustedUser))
                    {
                        continue;
                    }*/
                    isNewRow = false;
                    dr = dtUpdate.NewRow();
                    dr["id"] = npcId;
                    SetNPCLocationQuery(npcId, pUpdate, npc, sql);
                }
                else
                {
                    isNewRow = true;
                    dr = dtInsert.NewRow();
                    continue;
                }

                dr["version_id"] = pUpdate.ClientVersion.Value;
                dr["name_" + locale] = npc.Name;
                dr["min_level"] = npc.MinLevel;
                dr["max_level"] = npc.MaxLevel;

                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                foreach (StoreItem stitem in npc.Store)
                {
                    sql.AppendFormat(sNPCVendorQueryFormat, npcId, stitem.ItemID, stitem.Price, stitem.MoneyType);
                    DBItems.AddSource(stitem.ItemID, (byte)EItemSource.Vendor);
                }

                if (isNewRow)
                {
                    //dtInsert.Rows.Add(dr);
                    //cmd.CommandText = DB.GetFilledInsertSQL(sInsertQuery, sNpcInsertSchema, dr, sIgnoreInsertColumns, locale);
                    //npcId = (Int32)cmd.ExecuteScalar();
                    //AddNpc(npc.Name, locale, npcId);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }
            }
   



            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = sTempTableCreation;
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                   null))
                {
                    bulkUpdate.BatchSize = 5000;
                    bulkUpdate.DestinationTableName = "#npc";
                    bulkUpdate.WriteToServer(dtUpdate);
                    bulkUpdate.Close();
                }

                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #npc;";
                cmd.ExecuteNonQuery();
            }

            if (sql.Length > 0)
            {
                cmd.CommandText = sql.ToString();
                cmd.ExecuteNonQuery();
            }



        }
    }

}
