﻿using Curse;
using Curse.ROM;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace ROMDataService
{

    public static partial class DBObjects
    {

        private static Dictionary<CustomKey, Int32> sObjectNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sHistory =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sObjectConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sObjectLocationConfirmations =
    new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());



        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "posted", "posted_id", "version_id", "name" };
        private static String[] sIgnoreInsertColumns = { "id" };
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

        private static String sObjectLocationQueryFormat = "UPDATE object_location SET " +
                                                        "total=total+1," +
                                                        "updated_id={0}," +
                                                        "updated=GETUTCDATE()" +
                                                        " WHERE object_id={1} AND pos_x={4} AND pos_y = {5}" +
                                                        " IF @@ROWCOUNT = 0 " +
                                                        "INSERT INTO object_location(" +
                                                        "object_id,version_id,zone_id," +
                                                        "pos_x,pos_y,total,updated_id,posted_id) VALUES(" +
                                                        "{1},{2},{3},{4},{5},1,{0},{0});";


        private static String sTempTableCreation = "SELECT TOP 0 * INTO #object FROM object;ALTER TABLE #object DROP COLUMN id;ALTER TABLE #object ADD id int;";

        private static DataTable sObjectUpdateSchema = null;
        private static DataTable sObjectInsertSchema = null;


        public static void Initialize()
        {
            sHistory.Clear();
            sObjectNameToId.Clear();

            foreach (String locale in DB.sLocalizations)
            {
                DB.PopulateNameToID(sObjectNameToId, "object", locale);
            }
            DB.LoadSchema(ref sObjectUpdateSchema, "#object", sTempTableCreation);
            DB.LoadSchema(ref sObjectInsertSchema, "object");

            sInsertQuery = DB.GetInsertSQL(sObjectInsertSchema, sIgnoreInsertColumns);



            sUpdateQuery = "update object set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sObjectUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM object,#object tmp" +
                " WHERE object.id=tmp.id;";

        }

        public static Int32 GetObjectId(String pNpcName, String pLocale)
        {
            return DB.GetIdFromName(sObjectNameToId, pNpcName, pLocale);
        }

        public static void AddObject(String pNpcName, String pLocale, Int32 pObjectId)
        {
            DB.AddNameFromId(sObjectNameToId, pLocale, pNpcName, pObjectId);
        }

        private static void SetObjectLocationQuery(Int32 pObjectId, Update pUpdate, GameObject pObject, StringBuilder pBuilder)
        {
            // Locations
            foreach (EntityLocation location in pObject.Locations)
            {

                if (location.X == 0 && location.Y == 0 && location.Zone == 0)
                {
                    continue;
                }

                CustomKey key = new CustomKey(pObjectId,
                                            location.Zone,
                                            location.X,
                                            location.Y);

                /*if (!DB.IsEntityConfirmed(sNPCLocationConfirmations,
                                key,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                pUpdate.IsTrustedUser))
                {
                    continue;
                }*/

                pBuilder.AppendFormat(sObjectLocationQueryFormat,
                    pUpdate.UserId,
                    pObjectId,
                    pUpdate.ClientVersion.Value,
                    location.Zone,
                    location.X,
                    location.Y);
            }

        }




        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.GameObjects.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtInsert = sObjectUpdateSchema.Clone();
            DataTable dtUpdate = sObjectUpdateSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();
            SqlCommand cmd = pConn.CreateCommand();


            bool isNewRow = false;
            Int32 objId = 0;
            foreach (GameObject obj in pUpdate.GameObjects)
            {


                objId = GetObjectId(obj.Name, locale);
                if (objId > 0)
                {
                    /*if (!DB.ReadyForDB(sHistory,
                                sNPCConfirmations,
                                npcId,
                                Config.Instance.NpcExpiration,
                                Config.Instance.MinConfirmations,
                                pUpdate.UserId,
                                pUpdate.ClientVersion.Value,
                                (ELocale)pUpdate.Language,
                                pUpdate.IsTrustedUser))
                    {
                        continue;
                    }*/
                    isNewRow = false;
                    dr = dtUpdate.NewRow();
                    dr["id"] = objId;
                    SetObjectLocationQuery(objId, pUpdate, obj, sql);
                }
                else
                {
                    isNewRow = true;
                    dr = dtInsert.NewRow();
                }

                dr["version_id"] = pUpdate.ClientVersion.Value;
                dr["name_" + locale] = obj.Name;

                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;



                if (isNewRow)
                {
                    //dtInsert.Rows.Add(dr);
                    cmd.CommandText = DB.GetFilledInsertSQL(sInsertQuery, sObjectInsertSchema, dr, sIgnoreInsertColumns, locale);
                    objId = (Int32)cmd.ExecuteScalar();
                    AddObject(obj.Name, locale, objId);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }
            }




            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = sTempTableCreation;
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                   null))
                {
                    bulkUpdate.BatchSize = 5000;
                    bulkUpdate.DestinationTableName = "#object";
                    bulkUpdate.WriteToServer(dtUpdate);
                    bulkUpdate.Close();
                }

                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #object;";
                cmd.ExecuteNonQuery();
            }

            if (sql.Length > 0)
            {
                cmd.CommandText = sql.ToString();
                cmd.ExecuteNonQuery();
            }



        }
    }

}
