﻿using Curse;
using Curse.ROM;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace ROMDataService
{

    public static partial class DBQuests
    {
        private static HashSet<CustomKey> sKnownQuests =
    new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sHistory =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Int32> sQuestNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());




        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "posted", "posted_id", "version_id","name_en"};
        private static String[] sIgnoreInsertColumns = {  };
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();


        private static DataTable sNpcUpdateSchema = null;
        private static DataTable sNpcInsertSchema = null;

        private static DataTable sNpcMerchandiseSchema = null;

        public static void Initialize()
        {
            sHistory.Clear();
            sQuestNameToId.Clear();

            DB.PopulateNameToID(sQuestNameToId, "quest", "en");

            DB.LoadSchema(ref sNpcInsertSchema, "quest");
            sUpdateCustomColumns.Add("start_npc_id", "quest.start_npc_id = DBO.Highest(tmp.start_npc_id,quest.start_npc_id)");
            sUpdateCustomColumns.Add("end_npc_id", "quest.end_npc_id = DBO.Highest(tmp.end_npc_id,quest.end_npc_id)");



            sUpdateQuery = "update quest set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sNpcInsertSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM quest,#quest tmp" +
                " WHERE quest.id=tmp.id;";

        }

        public static Int32 GetQuestId(String pQuestName, String pLocale)
        {
            return DB.GetIdFromName(sQuestNameToId, pQuestName, pLocale);
        }

        public static void AddNpc(String pQuestName, String pLocale, Int32 pQuestId)
        {
            DB.AddNameFromId(sQuestNameToId, pLocale, pQuestName, pQuestId);
        }

        




        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.Quests.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtInsert = sNpcInsertSchema.Clone();
            DataTable dtUpdate = sNpcInsertSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();
            SqlCommand cmd = pConn.CreateCommand();


            bool isNewRow = false;
            Int32 questId = 0;
            foreach (Quest quest in pUpdate.Quests)
            {
                quest.name = quest.name.Replace(" (Complete)", "");
                questId = GetQuestId(quest.name, locale);

                if (questId > 0)
                {
                    isNewRow = false;
                    dr = dtUpdate.NewRow();
                    dr["id"] = questId;
                }
                else
                {
                    Logger.Log(ELogLevel.Error, pUpdate.UserHost, "Missing Quest From Service {0}", quest.name);
                    continue;
                    isNewRow = true;
                    dr = dtInsert.NewRow();
                }

                dr["money"] = quest.Money;
                dr["xp"] = quest.XP;
                dr["tp"] = quest.TP;
                dr["catalog"] = quest.Catalog;
                dr["start_npc_id"] = quest.StartNPC;
                dr["end_npc_id"] = quest.EndNPC;
                dr["version_id"] = pUpdate.ClientVersion.Value;

                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                if (isNewRow)
                {
                    dtInsert.Rows.Add(dr);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }
            }

            if (dtInsert.Rows.Count > 0)
            {

                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                    SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                    null))
                {
                    bulk.BatchSize = 5000;
                    bulk.DestinationTableName = "quest";
                    bulk.WriteToServer(dtInsert);
                }


            }


            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = "SELECT TOP 0 * INTO #quest FROM quest;";
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulkUpdate = new SqlBulkCopy(pConn,
                                                   SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                   null))
                {
                    bulkUpdate.BatchSize = 5000;
                    bulkUpdate.DestinationTableName = "#quest";
                    bulkUpdate.WriteToServer(dtUpdate);
                    bulkUpdate.Close();
                }

                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #quest;";
                cmd.ExecuteNonQuery();
            }




        }
    }

}
