﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using Curse.ServiceModels.Configuration;
using System.Data.SqlClient;
using Curse.ServerModService.Models;
using Curse.Extensions;

namespace Curse.ServerModService.Caching
{
    public class ServerModCache : IncrementalCache<ServerMod>
    {
        private static readonly ServerModCache _instance = new ServerModCache();
        public static ServerModCache Instance { get { return _instance; } }

        public ServerModCache() : base("Radon", "spGetServerMods") { }

        public override bool UpdateCache()
        {
            if (!base.UpdateCache())
            {
                return false;
            }
            return true;
        }

        public List<ServerMod> GetProjectsBySlug(string slug)
        {
            return CacheData.Where(p => p.Slug.Contains(slug)).ToList();
        }
    }
}