﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using Curse.ServiceModels.Attributes;
using Curse.ServerModService.Models;
using System.ServiceModel.Activation;

namespace Curse.ServerModService
{
    [ServiceContract]
    
    public interface IServerModService
    {
        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/servermods/projects?search={slug}")]
        List<ServerMod> Projects(string slug);

        [OperationContract]
        [RequiresAuthentication(AccessLevel.Anonymous)]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/servermods/files?projectids={ids}")]
        List<ServerModFile> Files(string ids);

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/")]
        string HealthCheck();
    
    }
}
