﻿using System;
using System.Runtime.Serialization;
using Curse.Extensions;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;

namespace Curse.ServerModService.Models
{
    
    [DataContract]
    public class ServerModFile : ICachable
    {
        private readonly string _mediaFileUrl = System.Configuration.ConfigurationManager.AppSettings["downloadUrl"];
        private readonly string _filePageUrl = System.Configuration.ConfigurationManager.AppSettings["filePageUrl"];

        public int ID { get; set; }

        [DataMember(Name = "downloadUrl")]
        public string DownloadUrl { get; set; }

        [DataMember(Name = "fileName")]
        public string FileName { get; set; }

        [DataMember(Name = "fileUrl")]
        public string FileUrl { get; set; }

        [DataMember(Name = "gameVersion")]
        public string GameVersion { get; set; }

        [DataMember(Name = "md5")]
        public string md5 { get; set; }

        [DataMember(Name = "name")]
        public string Name { get; set; }

        [DataMember(Name = "projectId")]
        public int ServerModId { get; set; }

        [DataMember(Name = "releaseType")]
        public string ReleaseType  { get; set; }

        #region ICachable Members

        public void SetFromDataReader(SqlDataReader reader)
        {
            this.ID = reader.GetInt32(reader.GetOrdinal("ID"));
            this.FileName = reader.GetString(reader.GetOrdinal("FileName"));
            //this must be set after getting FileName from the reader object.
            this.DownloadUrl = string.Format(_mediaFileUrl, ID.ToModPath(), FileName);
            this.FileUrl = string.Format(_filePageUrl, ID);
            this.GameVersion = reader.GetString(reader.GetOrdinal("GameVersion"));
            var md5 = reader.GetSqlBinary(reader.GetOrdinal("Md5"));
            if (md5.Length > 0)
            {
                this.md5 = md5.Value.ToHexString().ToLower();
            }            
            this.Name = reader.GetString(reader.GetOrdinal("Name"));
            this.ServerModId = reader.GetInt32(reader.GetOrdinal("ProjectID"));
            var name = Enum.GetName(typeof(EReleaseType), (EReleaseType)reader.GetByte(reader.GetOrdinal("ReleaseType")));
            if (name != null) this.ReleaseType = name.ToLower();
        }

        #endregion
    }
}