﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using TokenPlanFixer.BillingService;
using System.Configuration;
using System.Xml;

namespace TokenPlanFixer
{
    /// <summary>
    /// Wraps access to the Curse Billing Service
    /// </summary>
    public class BillingProvider
    {
        /// <summary>
        /// Instantiate and configure a new BillingProvider
        /// </summary>
        public BillingProvider()
        {
        }

        private static XmlDictionaryReaderQuotas GetDefaultReaderQuotas()
        {
            XmlDictionaryReaderQuotas readerQuotas = new XmlDictionaryReaderQuotas();
            readerQuotas.MaxArrayLength = 16384;
            readerQuotas.MaxBytesPerRead = 4096;
            readerQuotas.MaxNameTableCharCount = 16384;
            readerQuotas.MaxDepth = 64;
            readerQuotas.MaxStringContentLength = 640000;
            return readerQuotas;
        }
        public static WSHttpBinding GetDefaultWSHttpBinding()
        {
            // Reader quotas
            XmlDictionaryReaderQuotas readerQuotas = GetDefaultReaderQuotas();

            WSHttpBinding binding = new WSHttpBinding(SecurityMode.None, false);
            binding.AllowCookies = false;
            binding.CloseTimeout = TimeSpan.FromSeconds(10);
            binding.OpenTimeout = TimeSpan.FromSeconds(10);
            binding.ReceiveTimeout = TimeSpan.FromMinutes(1);
            binding.SendTimeout = TimeSpan.FromMinutes(1);
            binding.UseDefaultWebProxy = true;
            binding.BypassProxyOnLocal = false;
            binding.TransactionFlow = false;
            binding.HostNameComparisonMode = HostNameComparisonMode.StrongWildcard;
            binding.MaxBufferPoolSize = 524288;
            binding.MaxReceivedMessageSize = 2097152;
            binding.MessageEncoding = WSMessageEncoding.Text;
            binding.TextEncoding = Encoding.UTF8;
            binding.ReaderQuotas = readerQuotas;

            // Disable all builtin security
            binding.Security.Message.EstablishSecurityContext = false;
            binding.Security.Message.ClientCredentialType = MessageCredentialType.None;
            binding.Security.Message.NegotiateServiceCredential = false;
            binding.Security.Transport.ClientCredentialType = HttpClientCredentialType.None;

            return binding;
        }

        /// <summary>
        /// Return an instance of the remote billing service
        /// </summary>
        /// <returns></returns>
        public BillingServiceClient GetBillingServiceClient()
        {
            // The binding configuration
            WSHttpBinding binding = GetDefaultWSHttpBinding();

            string billingAddress = ConfigurationManager.AppSettings["BillingAddress"];
            // Create the client            
            return new BillingServiceClient(binding, new EndpointAddress(billingAddress));
        }


    }
}
