﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using TokenPlanFixer.BillingService;
using System.ServiceModel;
using System.Configuration;
using System.Xml;
using Vindicia;
using System.Threading;
using Curse.Billing.Configuration;

namespace TokenPlanFixer
{
    public static class BillingUtilities
    {
        public static void AddVentriloUsers(string[] bps)
        {
            BillingPlan bp;
            Return r;
            bool wasCreated;


            foreach (string bpid in bps)
            {
                bp = new BillingPlan();
                r = bp.fetchByMerchantBillingPlanId(bpid);
                if (r.returnCode != ReturnCode.Item200)
                {
                    Console.WriteLine(r.returnString);
                    return;
                }

                List<NameValuePair> metaData = bp.nameValues.ToList();
                if (!metaData.Any(nvp => nvp.name == "VentriloUsers"))
                {
                    metaData.Add(new NameValuePair() { name = "VentriloUsers", value = "0" });
                    bp.nameValues = metaData.ToArray();
                    r = bp.update(out wasCreated);
                    if (r.returnCode != ReturnCode.Item200)
                    {
                        Console.WriteLine(r.returnString);
                        return;
                    }
                }
            }
        }

        public static void BulkStatusUpdate(string[] bps, BillingPlanStatus status)
        {
            BillingPlan bp;
            Return r;
            bool wasCreated;


            foreach (string bpid in bps)
            {
                bp = new BillingPlan();
                r = bp.fetchByMerchantBillingPlanId(bpid);
                if (r.returnCode != ReturnCode.Item200)
                {
                    Console.WriteLine(r.returnString);
                    return;
                }
                bp.status = status;
                r = bp.update(out wasCreated);
                if (r.returnCode != ReturnCode.Item200)
                {
                    Console.WriteLine(r.returnString);
                    return;
                }
            }
        }

        /// <summary>
        /// Comp numDays to each subscription in the list
        /// </summary>
        /// <param name="subIDs"></param>
        /// <param name="numDays"></param>
        public static void BulkComp(IEnumerable<string> subIDs, int numDays, Func<AutoBill, bool> compSubDelegate)
        {
            AutoBill ab;
            Return r;
            Dictionary<string, string> failedSubs = new Dictionary<string, string>();


            foreach (string subID in subIDs)
            {
                try
                {
                    ab = new AutoBill();
                    r = ab.fetchByMerchantAutoBillId(subID);
                    if (r.returnCode != ReturnCode.Item200)
                    {
                        failedSubs[subID] = r.returnString;
                        continue;
                    }

                    if (compSubDelegate(ab))
                    {
                        DateTime origBillDate = ab.futureRebills[0].timestamp;
                        DateTime nextBillDate;
                        decimal nextBillAmt;
                        string nextBillCurr;
                        r = ab.delayBillingByDays(numDays, false, out nextBillDate, out nextBillAmt, out nextBillCurr);
                        r = ab.fetchByMerchantAutoBillId(subID);
                        if (r.returnCode != ReturnCode.Item200)
                        {
                            failedSubs[subID] = r.returnString;
                        }
                        else
                        {
                            Console.WriteLine(string.Format("{0} - {1} - {2}", ab.merchantAutoBillId, origBillDate, ab.futureRebills[0].timestamp));
                        }
                    }
                }
                catch (Exception e) {
                    Console.WriteLine(e.Message);
                }
            }
        }
    }
}
